/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.annotationprocessor;

import io.undertow.annotationprocessor.HttpParserConfig;
import io.undertow.annotationprocessor.HttpResponseParserConfig;
import io.undertow.annotationprocessor.RequestParserGenerator;
import io.undertow.annotationprocessor.ResponseParserGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"io.undertow.annotationprocessor.HttpParserConfig"})
@SupportedOptions(value={})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class HttpParserAnnotationProcessor
extends AbstractProcessor {
    private Filer filer;

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        RequestParserGenerator requestGenerator = new RequestParserGenerator();
        for (Element element : roundEnv.getElementsAnnotatedWith(HttpParserConfig.class)) {
            HttpParserConfig httpParserConfig = element.getAnnotation(HttpParserConfig.class);
            if (httpParserConfig == null) continue;
            byte[] newClass = requestGenerator.createTokenizer(((TypeElement)element).getQualifiedName().toString(), httpParserConfig.methods(), httpParserConfig.protocols(), httpParserConfig.headers());
            try {
                JavaFileObject file = this.filer.createClassFile(((TypeElement)element).getQualifiedName() + "$$generated", element);
                OutputStream out = file.openOutputStream();
                try {
                    out.write(newClass);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ResponseParserGenerator responseGenerator = new ResponseParserGenerator();
        for (Element element : roundEnv.getElementsAnnotatedWith(HttpResponseParserConfig.class)) {
            HttpResponseParserConfig parser = element.getAnnotation(HttpResponseParserConfig.class);
            if (parser == null) continue;
            byte[] newClass = responseGenerator.createTokenizer(((TypeElement)element).getQualifiedName().toString(), new String[0], parser.protocols(), parser.headers());
            try {
                JavaFileObject file = this.filer.createClassFile(((TypeElement)element).getQualifiedName() + "$$generated", element);
                OutputStream out = file.openOutputStream();
                try {
                    out.write(newClass);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

