/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.path;

import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.path.PathMappingServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletPathMappingTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(new ServletInfo("/a/*", PathMappingServlet.class).addMapping("/a/*"), new ServletInfo("/aa", PathMappingServlet.class).addMapping("/aa"), new ServletInfo("/aa/*", PathMappingServlet.class).addMapping("/aa/*"), new ServletInfo("/a/b/*", PathMappingServlet.class).addMapping("/a/b/*"), new ServletInfo("/", PathMappingServlet.class).addMapping("/"), new ServletInfo("*.jsp", PathMappingServlet.class).addMapping("*.jsp"), new ServletInfo("contextRoot", PathMappingServlet.class).addMapping(""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleHttpServlet() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/aa");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"/aa - /aa - null", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/a/c");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"/a/* - /a - /c", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/aa/b");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"/aa/* - /aa - /b", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/a/b/c/d");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"/a/b/* - /a/b - /c/d", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/a/b");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"/a/b/* - /a/b - null", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/defaultStuff");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"/ - /defaultStuff - null", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"contextRoot - / - null", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/bob.jsp");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"*.jsp - /bob.jsp - null", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/a/bob.jsp");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"/a/* - /a - /bob.jsp", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

