/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.websocket;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.servlet.websockets.WebSocketServlet;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.util.NetworkUtils;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import io.undertow.websockets.utils.FrameChecker;
import io.undertow.websockets.utils.WebSocketTestClient;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

@AjpIgnore
@RunWith(value=DefaultServer.class)
public class WebSocketServletTest {
    public static final Charset US_ASCII = Charset.forName("US-ASCII");

    @Test
    public void testText() throws Exception {
        final AtomicBoolean connected = new AtomicBoolean(false);
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentUtils.setupServlet(new ServletInfo("websocket", WebSocketServlet.class, (InstanceFactory)new ImmediateInstanceFactory((Object)new WebSocketServlet(new WebSocketConnectionCallback(){

            public void onConnect(final WebSocketHttpExchange exchange, WebSocketChannel channel) {
                connected.set(true);
                channel.getReceiveSetter().set((ChannelListener)new ChannelListener<WebSocketChannel>(){

                    public void handleEvent(final WebSocketChannel channel) {
                        try {
                            StreamSourceFrameChannel ws = (StreamSourceFrameChannel)channel.receive();
                            if (ws == null) {
                                return;
                            }
                            new StringReadChannelListener(exchange.getBufferPool()){

                                protected void stringDone(String string) {
                                    try {
                                        if (string.equals("hello")) {
                                            new StringWriteChannelListener("world").setup((StreamSinkChannel)channel.send(WebSocketFrameType.TEXT, (long)"world".length()));
                                        } else {
                                            new StringWriteChannelListener(string).setup((StreamSinkChannel)channel.send(WebSocketFrameType.TEXT, (long)string.length()));
                                        }
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        throw new RuntimeException(e);
                                    }
                                }

                                protected void error(IOException e) {
                                    try {
                                        e.printStackTrace();
                                        new StringWriteChannelListener("ERROR").setup((StreamSinkChannel)channel.send(WebSocketFrameType.TEXT, (long)"ERROR".length()));
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                        throw new RuntimeException(ex);
                                    }
                                }
                            }.setup((StreamSourceChannel)ws);
                            channel.getReceiveSetter().set(null);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                channel.resumeReceives();
            }
        }))).addMapping("/*"));
        FutureResult latch = new FutureResult();
        WebSocketTestClient client = new WebSocketTestClient(WebSocketVersion.V13, new URI("ws://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress((String)"default")) + ":" + DefaultServer.getHostPort((String)"default") + "/servletContext/"));
        client.connect();
        client.send((WebSocketFrame)new TextWebSocketFrame(ChannelBuffers.copiedBuffer((CharSequence)"hello", (Charset)US_ASCII)), (WebSocketTestClient.FrameListener)new FrameChecker(TextWebSocketFrame.class, "world".getBytes(US_ASCII), latch));
        latch.getIoFuture().get();
        client.destroy();
    }
}

