/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.response.writer;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResponseWriterServlet
extends HttpServlet {
    public static final String CONTENT_LENGTH_FLUSH = "content-length-flush";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String test = req.getParameter("test");
        if (!test.equals(CONTENT_LENGTH_FLUSH)) {
            throw new IllegalArgumentException("not a test " + test);
        }
        this.contentLengthFlush(req, resp);
    }

    private void contentLengthFlush(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int size = 10;
        PrintWriter pw = resp.getWriter();
        StringBuffer tmp = new StringBuffer(2 * size);
        pw.write("first-");
        resp.setContentLength(size);
        for (int i = 0; i < 20; ++i) {
            tmp = tmp.append("a");
        }
        pw.println(tmp);
        resp.addHeader("not-header", "not");
    }
}

