/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.custom;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.servlet.handlers.security.ServletFormAuthenticationMechanism;
import io.undertow.util.Methods;
import java.util.Map;

public class CustomAuthenticationMechanism
extends ServletFormAuthenticationMechanism {
    public static final String POST_LOCATION = "custom_security_check";
    public static final Factory FACTORY = new Factory();

    public CustomAuthenticationMechanism(String name, String loginPage, String errorPage) {
        super(FormParserFactory.builder().build(), name, loginPage, errorPage);
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRequestURI().endsWith(POST_LOCATION) && exchange.getRequestMethod().equals(Methods.POST)) {
            return this.runFormAuth(exchange, securityContext);
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public static final class Factory
    implements AuthenticationMechanismFactory {
        public AuthenticationMechanism create(String mechanismName, FormParserFactory formParserFactory, Map<String, String> properties) {
            return new CustomAuthenticationMechanism(mechanismName, properties.get("login_page"), properties.get("error_page"));
        }
    }
}

