/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.lifecycle;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.test.lifecycle.LifecycleFilter;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import javax.servlet.DispatcherType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class EagerServletLifecycleTestCase {
    @Test
    public void testServletLifecycle() throws Exception {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        FilterInfo f = new FilterInfo("filter", LifecycleFilter.class);
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(EagerServletLifecycleTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setEagerFilterInit(true).addFilter(f).addFilterUrlMapping("filter", "/aa", DispatcherType.REQUEST);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
        Assert.assertTrue((boolean)LifecycleFilter.initCalled);
    }
}

