/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.defaultservlet;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.path.ServletPathMappingTestCase;
import io.undertow.servlet.test.util.MessageFilter;
import io.undertow.servlet.test.util.PathTestServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FileUtils;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.BufferAllocator;

@RunWith(value=DefaultServer.class)
public class DefaultServletCachingListenerTestCase {
    private static final int MAX_FILE_SIZE = 20;
    private static final int MAX_WAIT_TIME = 20000;
    private static final int WAIT_TIME = 500;
    public static final String DIR_NAME = "cacheTest";
    private static Path tmpDir;
    private static final DirectBufferCache dataCache;

    @Before
    public void before() {
        for (Object k : dataCache.getAllKeys()) {
            dataCache.remove(k);
        }
    }

    @BeforeClass
    public static void setup() throws ServletException, IOException {
        tmpDir = Files.createTempDirectory(DIR_NAME, new FileAttribute[0]);
        Assume.assumeTrue((String)"WatchService is going to work OK", (FileSystems.getDefault().equals(tmpDir.getFileSystem()) && !FileSystems.getDefault().newWatchService().getClass().getName().equals("sun.nio.fs.PollingWatchService") ? 1 : 0) != 0);
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ServletPathMappingTestCase.class.getClassLoader()).setContextPath("/servletContext").addWelcomePage("index.html").setDeploymentName("servletContext.war").setResourceManager((ResourceManager)new CachingResourceManager(100, 20L, dataCache, (ResourceManager)new PathResourceManager(tmpDir, 0xA00000L, false, false, true, new String[0]), -1));
        builder.addServlet(new ServletInfo("DefaultTestServlet", PathTestServlet.class).addMapping("/path/default")).addFilter(Servlets.filter((String)"message", MessageFilter.class).addInitParam("message", "FILTER_TEXT ")).addFilterUrlMapping("message", "*.txt", DispatcherType.REQUEST);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @AfterClass
    public static void after() throws IOException {
        FileUtils.deleteRecursive((Path)tmpDir);
    }

    private static boolean waitUntilRefreshed(TestHttpClient client, String uri, int expectedStatus) throws IOException, InterruptedException {
        return DefaultServletCachingListenerTestCase.waitUntilRefreshed(client, uri, expectedStatus, null);
    }

    private static boolean waitUntilRefreshed(TestHttpClient client, String uri, int expectedStatus, String expectedResponse) throws IOException, InterruptedException {
        boolean ok = false;
        long startTime = System.currentTimeMillis();
        while (!ok && System.currentTimeMillis() - startTime < 20000L) {
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            if (result.getStatusLine().getStatusCode() == expectedStatus && (expectedResponse == null || expectedResponse.equals(response))) {
                ok = true;
                continue;
            }
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileExistanceCheckCached() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        String fileName = new SecureRandomSessionIdGenerator().createSessionId() + ".html";
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/" + fileName);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            Path f = tmpDir.resolve(fileName);
            Files.write(f, "hello".getBytes(), new OpenOption[0]);
            Assert.assertTrue((String)"File was not refreshed in 20000ms", (boolean)DefaultServletCachingListenerTestCase.waitUntilRefreshed(client, DefaultServer.getDefaultServerURL() + "/servletContext/" + fileName, 200, "hello"));
            Files.delete(f);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileContentsCached() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        String fileName = "hello.html";
        Path f = tmpDir.resolve(fileName);
        Files.write(f, "hello".getBytes(), new OpenOption[0]);
        try {
            for (int i = 0; i < 10; ++i) {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/" + fileName);
                CloseableHttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                String response = HttpClientUtils.readResponse((HttpResponse)result);
                Assert.assertEquals((Object)"hello", (Object)response);
            }
            Files.write(f, "hello world".getBytes(), new OpenOption[0]);
            Assert.assertTrue((String)"File was not refreshed in 20000ms", (boolean)DefaultServletCachingListenerTestCase.waitUntilRefreshed(client, DefaultServer.getDefaultServerURL() + "/servletContext/" + fileName, 200, "hello world"));
            Files.delete(f);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileContentsCachedWithFilter() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        String fileName = "hello.txt";
        Path f = tmpDir.resolve(fileName);
        Files.write(f, "hello".getBytes(), new OpenOption[0]);
        try {
            for (int i = 0; i < 10; ++i) {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/" + fileName);
                CloseableHttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                String response = HttpClientUtils.readResponse((HttpResponse)result);
                Assert.assertEquals((Object)"FILTER_TEXT hello", (Object)response);
            }
            Files.write(f, "hello world".getBytes(), new OpenOption[0]);
            Assert.assertTrue((String)"File was not refreshed in 20000ms", (boolean)DefaultServletCachingListenerTestCase.waitUntilRefreshed(client, DefaultServer.getDefaultServerURL() + "/servletContext/" + fileName, 200, "FILTER_TEXT hello world"));
            Files.delete(f);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRangeRequest() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            String fileName = "range.html";
            Path f = tmpDir.resolve(fileName);
            Files.write(f, "hello".getBytes(), new OpenOption[0]);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/range.html");
            get.addHeader("range", "bytes=2-3");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"ll", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRangeRequestFileNotInCache() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            String fileName = "range_not_in_cache.html";
            Path f = tmpDir.resolve(fileName);
            Files.write(f, "hello world and once again hello world".getBytes(), new OpenOption[0]);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/range_not_in_cache.html");
            get.addHeader("range", "bytes=2-3");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"ll", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWelcomePages() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            String fileName = "index.html";
            String content = "<html></html>";
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/" + fileName);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            Path f = tmpDir.resolve(fileName);
            Files.write(f, content.getBytes(), new OpenOption[0]);
            Assert.assertTrue((String)"File was not refreshed in 20000ms", (boolean)DefaultServletCachingListenerTestCase.waitUntilRefreshed(client, DefaultServer.getDefaultServerURL() + "/servletContext/" + fileName, 200, content));
            Assert.assertTrue((String)"File was not refreshed in 20000ms", (boolean)DefaultServletCachingListenerTestCase.waitUntilRefreshed(client, DefaultServer.getDefaultServerURL() + "/servletContext/", 200, content));
            Files.delete(f);
            Assert.assertTrue((String)"File was not refreshed in 20000ms", (boolean)DefaultServletCachingListenerTestCase.waitUntilRefreshed(client, DefaultServer.getDefaultServerURL() + "/servletContext/" + fileName, 404));
            Assert.assertTrue((String)"File was not refreshed in 20000ms", (boolean)DefaultServletCachingListenerTestCase.waitUntilRefreshed(client, DefaultServer.getDefaultServerURL() + "/servletContext/", 403));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    static {
        dataCache = new DirectBufferCache(1000, 10, 10000000, BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, -1);
    }
}

