/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.push;

import java.io.IOException;
import java.util.Base64;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.PushBuilder;

public class PushServlet
extends HttpServlet {
    private static final String PNG_BASE64 = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mNkYPhfDwAChwGA60e6kgAAAABJRU5ErkJggg==";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getServletPath().endsWith(".html") || request.getPathInfo().endsWith(".html")) {
            PushBuilder pushBuilder = request.newPushBuilder();
            if (pushBuilder != null) {
                pushBuilder.path("resources/one.css").push();
                pushBuilder.path("resources/one.js").push();
            }
            try (ServletOutputStream out = response.getOutputStream();){
                out.println("<html>");
                out.println("  <head>");
                out.println("    <link type=\"text/css\" rel=\"stylesheet\" href=\"resources/one.css\" />");
                out.println("    <script type=\"text/javascript\" src=\"resources/one.js\"></script>");
                out.println("  </head>");
                out.println("  <body>");
                out.println("    <span class=\"border\">PUSH PROMISES</span>");
                out.println("  </body>");
                out.println("</html>");
            }
        } else if (request.getPathInfo().endsWith(".css")) {
            PushBuilder pushBuilder = request.newPushBuilder();
            if (pushBuilder != null) {
                pushBuilder.path("resources/one.png").push();
            }
            response.setContentType("text/css");
            try (ServletOutputStream out = response.getOutputStream();){
                out.println("body, html {");
                out.println("  height: 100%;");
                out.println("  margin: 0;");
                out.println("  background-image: url(\"one.png\");");
                out.println("  background-repeat: repeat;");
                out.println("}");
            }
        } else if (request.getPathInfo().endsWith(".js")) {
            response.setContentType("application/javascript");
            try (ServletOutputStream out = response.getOutputStream();){
                out.println("console.log('loading js file ' + location.pathname);");
            }
        } else if (request.getPathInfo().endsWith(".png")) {
            byte[] bytes = Base64.getDecoder().decode(PNG_BASE64);
            response.setContentType("image/png");
            try (ServletOutputStream out = response.getOutputStream();){
                out.write(bytes);
            }
        } else {
            throw new ServletException("Invalid request");
        }
    }
}

