/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.lifecycle;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.lifecycle.LifeCycleServlet;
import io.undertow.servlet.test.lifecycle.LifecycleFilter;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import javax.servlet.DispatcherType;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletLifecycleTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletLifecycle() throws Exception {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", LifeCycleServlet.class).addMapping("/aa");
        FilterInfo f = new FilterInfo("filter", LifecycleFilter.class);
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(ServletLifecycleTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlet(s).addFilter(f).addFilterUrlMapping("filter", "/aa", DispatcherType.REQUEST);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/aa");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            manager.stop();
            manager.undeploy();
            Assert.assertTrue((boolean)LifeCycleServlet.initCalled);
            Assert.assertTrue((boolean)LifeCycleServlet.destroyCalled);
            Assert.assertTrue((boolean)LifecycleFilter.initCalled);
            Assert.assertTrue((boolean)LifecycleFilter.destroyCalled);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

