/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.response.cookies;

import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.response.cookies.AddCookiesServlet;
import io.undertow.servlet.test.response.cookies.DuplicateCookiesServlet;
import io.undertow.servlet.test.response.cookies.JSessionIDCookiesServlet;
import io.undertow.servlet.test.response.cookies.OverwriteCookiesServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.util.Arrays;
import java.util.Comparator;
import javax.servlet.ServletException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ResponseCookiesTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(new ServletInfo("add-cookies", AddCookiesServlet.class).addMapping("/add-cookies"), new ServletInfo("duplicate-cookies", DuplicateCookiesServlet.class).addMapping("/duplicate-cookies"), new ServletInfo("overwrite-cookies", OverwriteCookiesServlet.class).addMapping("/overwrite-cookies"), new ServletInfo("jsessionid-cookies", JSessionIDCookiesServlet.class).addMapping("/jsessionid-cookies"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addCookies() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/add-cookies");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Served at: /servletContext", (Object)response);
            Header[] setCookieHeaders = result.getHeaders("Set-Cookie");
            Assert.assertEquals((long)2L, (long)setCookieHeaders.length);
            Assert.assertEquals((Object)"test1=test1; path=/test", (Object)setCookieHeaders[0].getValue());
            Assert.assertEquals((Object)"test2=test2", (Object)setCookieHeaders[1].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void duplicateCookies() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/duplicate-cookies");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Served at: /servletContext", (Object)response);
            Header[] setCookieHeaders = result.getHeaders("Set-Cookie");
            Assert.assertEquals((long)7L, (long)setCookieHeaders.length);
            Arrays.sort(setCookieHeaders, Comparator.comparing(Object::toString));
            Assert.assertEquals((Object)"test1=test1; path=/test1_1", (Object)setCookieHeaders[0].getValue());
            Assert.assertEquals((Object)"test1=test1; path=/test1_2", (Object)setCookieHeaders[1].getValue());
            Assert.assertEquals((Object)"test2=test2; path=/test2", (Object)setCookieHeaders[2].getValue());
            Assert.assertEquals((Object)"test2=test2; path=/test2; domain=www.domain2.com", (Object)setCookieHeaders[3].getValue());
            Assert.assertEquals((Object)"test3=test3", (Object)setCookieHeaders[4].getValue());
            Assert.assertEquals((Object)"test3=test3; domain=www.domain3-1.com", (Object)setCookieHeaders[5].getValue());
            Assert.assertEquals((Object)"test3=test3; domain=www.domain3-2.com", (Object)setCookieHeaders[6].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void overwriteCookies() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/overwrite-cookies");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Served at: /servletContext", (Object)response);
            Header[] setCookieHeaders = result.getHeaders("Set-Cookie");
            Assert.assertEquals((long)5L, (long)setCookieHeaders.length);
            Arrays.sort(setCookieHeaders, Comparator.comparing(Object::toString));
            Assert.assertTrue((String)("Header " + setCookieHeaders[0] + "didn't match expected regex"), (boolean)setCookieHeaders[0].getValue().matches("JSESSIONID=.*; path=/servletContext"));
            Assert.assertEquals((Object)"test=test10; domain=www.domain.com", (Object)setCookieHeaders[1].getValue());
            Assert.assertEquals((Object)"test=test2; path=/test", (Object)setCookieHeaders[2].getValue());
            Assert.assertEquals((Object)"test=test5", (Object)setCookieHeaders[3].getValue());
            Assert.assertEquals((Object)"test=test8; path=/test; domain=www.domain.com", (Object)setCookieHeaders[4].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsessionIdCookies() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/jsessionid-cookies");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Served at: /servletContext", (Object)response);
            Header[] setCookieHeaders = result.getHeaders("Set-Cookie");
            Assert.assertEquals((long)3L, (long)setCookieHeaders.length);
            Assert.assertTrue((String)("Header " + setCookieHeaders[0] + "didn't start with expected prefix"), (boolean)setCookieHeaders[0].getValue().startsWith("JSESSIONID=_bug_fix; path=/path3; Max-Age=500; Expires="));
            Assert.assertTrue((String)("Header " + setCookieHeaders[1] + "didn't start with expected prefix"), (boolean)setCookieHeaders[1].getValue().startsWith("JSESSIONID=_bug_fix; path=/path4; Max-Age=1000; Expires="));
            Assert.assertTrue((String)("Header " + setCookieHeaders[2] + "didn't match expected regex"), (boolean)setCookieHeaders[2].getValue().matches("JSESSIONID=.*; path=/servletContext"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

