/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.response.writer;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.test.response.writer.LargeResponseWriterServlet;
import io.undertow.servlet.test.response.writer.ResponseWriterServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FileUtils;
import java.io.InputStream;
import javax.servlet.ServletException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ResponseWriterTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ResponseWriterTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war").addServlet(Servlets.servlet((String)"resp", ResponseWriterServlet.class).addMapping("/resp")).addServlet(Servlets.servlet((String)"respLArget", LargeResponseWriterServlet.class).addMapping("/large"));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContentLengthBasedFlush() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/resp?test=" + "content-length-flush");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String data = FileUtils.readFile((InputStream)result.getEntity().getContent());
            Assert.assertEquals((Object)"first-aaaa", (Object)data);
            Assert.assertEquals((long)0L, (long)result.getHeaders("not-header").length);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriterLargeResponse() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/large");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String data = FileUtils.readFile((InputStream)result.getEntity().getContent());
            Assert.assertEquals((Object)LargeResponseWriterServlet.getMessage(), (Object)data);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

