/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.basic;

import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.security.MultipartAcceptingServlet;
import io.undertow.servlet.test.security.constraint.ServletIdentityManager;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLContext;
import javax.servlet.MultipartConfigElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

@RunWith(value=DefaultServer.class)
public class ServletCertAndDigestAuthTestCase {
    private static final String REALM_NAME = "Servlet_Realm";
    private static final String BASE_PATH = "/servletContext/secured/";
    private static SSLContext clientSSLContext;

    @BeforeClass
    public static void startSSL() throws Exception {
        DefaultServer.startSSLServer((OptionMap)OptionMap.create((Option)Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.NOT_REQUESTED));
        clientSSLContext = DefaultServer.getClientSSLContext();
        PathHandler path = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo multipartServlet = new ServletInfo("Multipart Accepting Servlet", MultipartAcceptingServlet.class).addMapping("/secured/multipart").setMultipartConfig(new MultipartConfigElement(""));
        ServletIdentityManager identityManager = new ServletIdentityManager();
        identityManager.addUser("user1", "password1", "role1");
        identityManager.addUser("charsetUser", "password-\u00fc", "role1");
        LoginConfig loginConfig = new LoginConfig(REALM_NAME);
        loginConfig.addFirstAuthMethod(new AuthMethodConfig("BASIC"));
        loginConfig.addFirstAuthMethod(new AuthMethodConfig("CLIENT_CERT"));
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setIdentityManager((IdentityManager)identityManager).setLoginConfig(loginConfig).addServlets(new ServletInfo[]{multipartServlet});
        builder.addSecurityConstraint((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/secured/*")).addRoleAllowed("role1")).setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.DENY));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        path.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)path);
    }

    @AfterClass
    public static void stopSSL() throws Exception {
        clientSSLContext = null;
        DefaultServer.stopSSLServer();
    }

    @Test
    public void testMultipartRequest() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 2000; ++i) {
            sb.append("0123456789");
        }
        try (TestHttpClient client = new TestHttpClient();){
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addPart("part1", (ContentBody)new ByteArrayBody(sb.toString().getBytes(), "file.txt"));
            builder.addPart("part2", (ContentBody)new StringBody("0123456789", ContentType.TEXT_HTML));
            HttpEntity entity = builder.build();
            client.setSSLContext(clientSSLContext);
            String url = DefaultServer.getDefaultServerSSLAddress() + BASE_PATH + "multipart";
            HttpPost post = new HttpPost(url);
            post.setEntity(entity);
            post.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"user1:password1".getBytes(StandardCharsets.UTF_8), (boolean)false));
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        }
    }
}

