/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.custom;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.idm.IdentityManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.security.SendUsernameServlet;
import io.undertow.servlet.test.security.constraint.ServletIdentityManager;
import io.undertow.servlet.test.security.custom.CustomEncodingAuthenticationMechanism;
import io.undertow.servlet.test.security.form.FormLoginServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import java.util.List;
import javax.servlet.ServletException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletCustomAuthFormEncodingTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthFormEncoding() throws ServletException {
        CustomEncodingAuthenticationMechanism authenticationMechanism;
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", SendUsernameServlet.class).setServletSecurityInfo((ServletSecurityInfo)new ServletSecurityInfo().addRoleAllowed("role1")).addMapping("/secured/*");
        ServletInfo s1 = new ServletInfo("loginPage", FormLoginServlet.class).setServletSecurityInfo((ServletSecurityInfo)new ServletSecurityInfo().addRoleAllowed("group1")).addMapping("/FormLoginServlet");
        ServletIdentityManager identityManager = new ServletIdentityManager();
        identityManager.addUser("user1", "password1", "role1");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setIdentityManager((IdentityManager)identityManager).setLoginConfig(new LoginConfig("FORM", "Test Realm", "/FormLoginServlet", "/error.html")).addServlets(new ServletInfo[]{s, s1}).addAuthenticationMechanism("FORM", (AuthenticationMechanismFactory)CustomEncodingAuthenticationMechanism.FACTORY);
        DeploymentManager manager = container.addDeployment(builder);
        try {
            manager.deploy();
            authenticationMechanism = this.getCustomeAuth(manager);
            Assert.assertEquals((Object)"ISO-8859-1", (Object)authenticationMechanism.charset);
        }
        finally {
            manager.undeploy();
        }
        builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext2.war").setIdentityManager((IdentityManager)identityManager).setLoginConfig(new LoginConfig("FORM", "Test Realm", "/FormLoginServlet", "/error.html")).addServlets(new ServletInfo[]{s, s1}).setDefaultRequestEncoding("UTF-8").addAuthenticationMechanism("FORM", (AuthenticationMechanismFactory)CustomEncodingAuthenticationMechanism.FACTORY);
        manager = container.addDeployment(builder);
        try {
            manager.deploy();
            authenticationMechanism = this.getCustomeAuth(manager);
            Assert.assertEquals((Object)"UTF-8", (Object)authenticationMechanism.charset);
        }
        finally {
            manager.undeploy();
        }
        builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext3.war").setIdentityManager((IdentityManager)identityManager).setLoginConfig(new LoginConfig("FORM", "Test Realm", "/FormLoginServlet", "/error.html")).addServlets(new ServletInfo[]{s, s1}).setDefaultEncoding("UTF-8").addAuthenticationMechanism("FORM", (AuthenticationMechanismFactory)CustomEncodingAuthenticationMechanism.FACTORY);
        manager = container.addDeployment(builder);
        try {
            manager.deploy();
            authenticationMechanism = this.getCustomeAuth(manager);
            Assert.assertEquals((Object)"UTF-8", (Object)authenticationMechanism.charset);
        }
        finally {
            manager.undeploy();
        }
    }

    private CustomEncodingAuthenticationMechanism getCustomeAuth(DeploymentManager manager) {
        List authenticationMechanismList = manager.getDeployment().getAuthenticationMechanisms();
        for (AuthenticationMechanism authenticationMechanism : authenticationMechanismList) {
            if (!(authenticationMechanism instanceof CustomEncodingAuthenticationMechanism)) continue;
            return (CustomEncodingAuthenticationMechanism)authenticationMechanism;
        }
        return null;
    }
}

