/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.api.SessionManagerFactory;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.session.LastAccessTimeSessionServlet;
import io.undertow.servlet.test.session.SessionServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class CrossContextServletSharedSessionTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        ServletContainer container = ServletContainer.Factory.newInstance();
        PathHandler path = new PathHandler();
        DefaultServer.setRootHandler((HttpHandler)path);
        InMemorySessionManager manager = new InMemorySessionManager("test");
        CrossContextServletSharedSessionTestCase.createDeployment("1", container, path, manager);
        CrossContextServletSharedSessionTestCase.createDeployment("2", container, path, manager);
    }

    private static void createDeployment(String name, ServletContainer container, PathHandler path, final InMemorySessionManager sessionManager) throws ServletException {
        ServletInfo s = new ServletInfo("servlet", SessionServlet.class).addMapping("/servlet");
        ServletInfo forward = new ServletInfo("forward", ForwardServlet.class).addMapping("/forward");
        ServletInfo include = new ServletInfo("include", IncludeServlet.class).addMapping("/include");
        ServletInfo includeAdd = new ServletInfo("includeadd", IncludeAddServlet.class).addMapping("/includeadd");
        ServletInfo forwardAdd = new ServletInfo("forwardadd", ForwardAddServlet.class).addMapping("/forwardadd");
        ServletInfo accessTimeServlet = new ServletInfo("accesstimeservlet", LastAccessTimeSessionServlet.class).addMapping("/accesstimeservlet");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/" + name).setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName(name + ".war").setSessionManagerFactory(new SessionManagerFactory(){

            public SessionManager createSessionManager(Deployment deployment) {
                return sessionManager;
            }
        }).setServletSessionConfig(new ServletSessionConfig().setPath("/")).addServlets(new ServletInfo[]{s, forward, include, forwardAdd, includeAdd, accessTimeServlet});
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        path.addPrefixPath(builder.getContextPath(), manager.start());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedSessionCookieMultipleDeployments() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet direct1 = new HttpGet(DefaultServer.getDefaultServerURL() + "/1/servlet");
            HttpGet direct2 = new HttpGet(DefaultServer.getDefaultServerURL() + "/2/servlet");
            CloseableHttpResponse result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"1", (Object)response);
            result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"2", (Object)response);
            result = client.execute((HttpUriRequest)direct2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"3", (Object)response);
            result = client.execute((HttpUriRequest)direct2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"4", (Object)response);
            result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"5", (Object)response);
            result = client.execute((HttpUriRequest)direct2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"6", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCrossContextSessionForwardInvocation() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet direct1 = new HttpGet(DefaultServer.getDefaultServerURL() + "/1/servlet");
            HttpGet forward1 = new HttpGet(DefaultServer.getDefaultServerURL() + "/1/forward?context=/2&path=/servlet");
            HttpGet direct2 = new HttpGet(DefaultServer.getDefaultServerURL() + "/2/servlet");
            HttpGet forward2 = new HttpGet(DefaultServer.getDefaultServerURL() + "/2/forward?context=/1&path=/servlet");
            CloseableHttpResponse result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"1", (Object)response);
            result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"2", (Object)response);
            result = client.execute((HttpUriRequest)forward2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"3", (Object)response);
            result = client.execute((HttpUriRequest)forward2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"4", (Object)response);
            result = client.execute((HttpUriRequest)forward1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"5", (Object)response);
            result = client.execute((HttpUriRequest)forward1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"6", (Object)response);
            result = client.execute((HttpUriRequest)direct2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"7", (Object)response);
            result = client.execute((HttpUriRequest)direct2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"8", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCrossContextSessionForwardAccessTimeInvocation() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet direct1 = new HttpGet(DefaultServer.getDefaultServerURL() + "/1/accesstimeservlet");
            HttpGet forward1 = new HttpGet(DefaultServer.getDefaultServerURL() + "/1/forward?context=/2&path=/accesstimeservlet");
            CloseableHttpResponse result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.startsWith("1 "));
            result = client.execute((HttpUriRequest)forward1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.startsWith("2 "));
            Thread.sleep(50L);
            result = client.execute((HttpUriRequest)forward1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.startsWith("3 "));
            Long time1 = Long.parseLong(response.substring(2));
            Thread.sleep(50L);
            result = client.execute((HttpUriRequest)forward1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.startsWith("4 "));
            Long time2 = Long.parseLong(response.substring(2));
            Assert.assertTrue((time2 > time1 ? 1 : 0) != 0);
            result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.startsWith("5 "));
            Long time3 = Long.parseLong(response.substring(2));
            Assert.assertTrue((time3 > time2 ? 1 : 0) != 0);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCrossContextSessionForwardInvocationWithBothServletsAdding() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet direct1 = new HttpGet(DefaultServer.getDefaultServerURL() + "/1/servlet");
            HttpGet forward1 = new HttpGet(DefaultServer.getDefaultServerURL() + "/1/forwardadd?context=/2&path=/servlet");
            HttpGet direct2 = new HttpGet(DefaultServer.getDefaultServerURL() + "/2/servlet");
            HttpGet forward2 = new HttpGet(DefaultServer.getDefaultServerURL() + "/2/forwardadd?context=/1&path=/servlet");
            CloseableHttpResponse result = client.execute((HttpUriRequest)forward1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"2", (Object)response);
            result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"3", (Object)response);
            result = client.execute((HttpUriRequest)forward2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"5", (Object)response);
            result = client.execute((HttpUriRequest)forward2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"7", (Object)response);
            result = client.execute((HttpUriRequest)forward1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"9", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCrossContextSessionIncludeInvocation() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet direct1 = new HttpGet(DefaultServer.getDefaultServerURL() + "/1/servlet");
            HttpGet include1 = new HttpGet(DefaultServer.getDefaultServerURL() + "/1/include?context=/2&path=/servlet");
            HttpGet direct2 = new HttpGet(DefaultServer.getDefaultServerURL() + "/2/servlet");
            HttpGet include2 = new HttpGet(DefaultServer.getDefaultServerURL() + "/2/include?context=/1&path=/servlet");
            CloseableHttpResponse result = client.execute((HttpUriRequest)include2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"1", (Object)response);
            result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"2", (Object)response);
            result = client.execute((HttpUriRequest)include2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"3", (Object)response);
            result = client.execute((HttpUriRequest)include2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"4", (Object)response);
            result = client.execute((HttpUriRequest)include1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"5", (Object)response);
            result = client.execute((HttpUriRequest)include1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"6", (Object)response);
            result = client.execute((HttpUriRequest)direct2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"7", (Object)response);
            result = client.execute((HttpUriRequest)direct2);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"8", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCrossContextSessionIncludeAccessTimeInvocation() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet direct1 = new HttpGet(DefaultServer.getDefaultServerURL() + "/1/accesstimeservlet");
            HttpGet include1 = new HttpGet(DefaultServer.getDefaultServerURL() + "/1/include?context=/2&path=/accesstimeservlet");
            CloseableHttpResponse result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.startsWith("1 "));
            result = client.execute((HttpUriRequest)include1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.startsWith("2 "));
            Thread.sleep(50L);
            result = client.execute((HttpUriRequest)include1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.startsWith("3 "));
            Long time1 = Long.parseLong(response.substring(2));
            Thread.sleep(50L);
            result = client.execute((HttpUriRequest)include1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.startsWith("4 "));
            Long time2 = Long.parseLong(response.substring(2));
            Assert.assertTrue((time2 > time1 ? 1 : 0) != 0);
            result = client.execute((HttpUriRequest)direct1);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.startsWith("5 "));
            Long time3 = Long.parseLong(response.substring(2));
            Assert.assertTrue((time3 > time2 ? 1 : 0) != 0);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    public static class IncludeAddServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            HttpSession session = req.getSession();
            Integer value = (Integer)session.getAttribute("key");
            if (value == null) {
                value = 1;
            }
            session.setAttribute("key", (Object)(value + 1));
            req.getServletContext().getContext(req.getParameter("context")).getRequestDispatcher(req.getParameter("path")).include((ServletRequest)req, (ServletResponse)resp);
        }
    }

    public static class ForwardAddServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            HttpSession session = req.getSession();
            Integer value = (Integer)session.getAttribute("key");
            if (value == null) {
                value = 1;
            }
            session.setAttribute("key", (Object)(value + 1));
            req.getServletContext().getContext(req.getParameter("context")).getRequestDispatcher(req.getParameter("path")).forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    public static class IncludeServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            req.getServletContext().getContext(req.getParameter("context")).getRequestDispatcher(req.getParameter("path")).include((ServletRequest)req, (ServletResponse)resp);
        }
    }

    public static class ForwardServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            req.getServletContext().getContext(req.getParameter("context")).getRequestDispatcher(req.getParameter("path")).forward((ServletRequest)req, (ServletResponse)resp);
        }
    }
}

