/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.util;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.RangeAwareResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;

public class TestResourceLoader
extends ClassPathResourceManager {
    public TestResourceLoader(Class<?> testClass) {
        super(testClass.getClassLoader(), testClass.getPackage().getName().replace(".", "/"));
    }

    public Resource getResource(String path) throws IOException {
        Resource delegate = super.getResource(path);
        if (delegate == null) {
            return delegate;
        }
        return new TestResource(delegate);
    }

    private static class TestResource
    implements RangeAwareResource {
        private final Resource delegate;

        TestResource(Resource delegate) {
            this.delegate = delegate;
        }

        public String getPath() {
            return this.delegate.getPath();
        }

        public Date getLastModified() {
            return this.delegate.getLastModified();
        }

        public String getLastModifiedString() {
            return this.delegate.getLastModifiedString();
        }

        public ETag getETag() {
            return this.delegate.getETag();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public boolean isDirectory() {
            return this.delegate.isDirectory();
        }

        public List<Resource> list() {
            return this.delegate.list();
        }

        public String getContentType(MimeMappings mimeMappings) {
            return this.delegate.getContentType(mimeMappings);
        }

        public void serve(Sender sender, HttpServerExchange exchange, IoCallback completionCallback) {
            this.delegate.serve(sender, exchange, completionCallback);
        }

        public Long getContentLength() {
            return this.delegate.getContentLength();
        }

        public String getCacheKey() {
            return this.delegate.getCacheKey();
        }

        public File getFile() {
            return this.delegate.getFile();
        }

        public Path getFilePath() {
            return this.delegate.getFilePath();
        }

        public File getResourceManagerRoot() {
            return this.delegate.getResourceManagerRoot();
        }

        public Path getResourceManagerRootPath() {
            return this.delegate.getResourceManagerRootPath();
        }

        public URL getUrl() {
            return this.delegate.getUrl();
        }

        public void serveRange(Sender sender, HttpServerExchange exchange, long start, long end, IoCallback completionCallback) {
            ((RangeAwareResource)this.delegate).serveRange(sender, exchange, start, end, completionCallback);
        }

        public boolean isRangeSupported() {
            return this.delegate instanceof RangeAwareResource && ((RangeAwareResource)this.delegate).isRangeSupported();
        }
    }
}

