/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.websocket;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.servlet.websockets.WebSocketServlet;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.util.NetworkUtils;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import io.undertow.websockets.utils.FrameChecker;
import io.undertow.websockets.utils.WebSocketTestClient;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;

@HttpOneOnly
@RunWith(value=DefaultServer.class)
public class WebSocketServletTest {
    public static final Charset US_ASCII = StandardCharsets.US_ASCII;

    @Test
    public void testText() throws Exception {
        final AtomicBoolean connected = new AtomicBoolean(false);
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentUtils.setupServlet(new ServletInfo("websocket", WebSocketServlet.class, (InstanceFactory)new ImmediateInstanceFactory((Object)new WebSocketServlet(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                connected.set(true);
                channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

                    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
                        String string = message.getData();
                        if (string.equals("hello")) {
                            WebSockets.sendText((String)"world", (WebSocketChannel)channel, null);
                        } else {
                            WebSockets.sendText((String)string, (WebSocketChannel)channel, null);
                        }
                    }
                });
                channel.resumeReceives();
            }
        }))).addMapping("/*"));
        FutureResult latch = new FutureResult();
        WebSocketTestClient client = new WebSocketTestClient(WebSocketVersion.V13, new URI("ws://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress((String)"default")) + ":" + DefaultServer.getHostPort((String)"default") + "/servletContext/"));
        client.connect();
        client.send((WebSocketFrame)new TextWebSocketFrame(Unpooled.copiedBuffer((CharSequence)"hello", (Charset)US_ASCII)), (WebSocketTestClient.FrameListener)new FrameChecker(TextWebSocketFrame.class, "world".getBytes(US_ASCII), latch));
        latch.getIoFuture().get();
        client.destroy();
    }
}

