/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.wrapper;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ExceptionHandler;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.LoggingExceptionHandler;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.wrapper.NonStandardRequestWrappingFilter;
import io.undertow.servlet.test.wrapper.StandardRequestWrapper;
import io.undertow.servlet.test.wrapper.StandardRequestWrappingFilter;
import io.undertow.servlet.test.wrapper.StandardResponseWrapper;
import io.undertow.servlet.test.wrapper.WrapperServlet;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public abstract class AbstractResponseWrapperTestCase {
    @Before
    public void setup() throws ServletException {
        DeploymentInfo builder = new DeploymentInfo();
        builder.setExceptionHandler((ExceptionHandler)LoggingExceptionHandler.builder().add(IllegalArgumentException.class, "io.undertow", Logger.Level.DEBUG).build());
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        builder.addServlet(new ServletInfo("wrapperServlet", WrapperServlet.class).addMapping("/*"));
        builder.addFilter(new FilterInfo("standard", StandardRequestWrappingFilter.class));
        builder.addFilterUrlMapping("standard", "/standard", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("nonstandard", NonStandardRequestWrappingFilter.class));
        builder.addFilterUrlMapping("nonstandard", "/nonstandard", DispatcherType.REQUEST);
        builder.setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(AbstractResponseWrapperTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war").setAllowNonStandardWrappers(this.isNonStandardAllowed());
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    abstract boolean isNonStandardAllowed();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoWrapper() throws IOException, ServletException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)(HttpServletRequestImpl.class.getName() + "\n" + HttpServletResponseImpl.class.getName()), (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStandardWrapper() throws IOException, ServletException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/standard");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)(StandardRequestWrapper.class.getName() + "\n" + StandardResponseWrapper.class.getName()), (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

