package io.uok.spacex.database;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ConfigurationProperties(prefix = "spacex.db")
@ConditionalOnProperty(name = "spacex.db.enable", havingValue = "true", matchIfMissing = true)
@EnableTransactionManagement
@EnableJpaAuditing
public class DatabaseConfig {

  @Value("${spacex.db.url}")
  private String url;
  @Value("${spacex.db.username}")
  private String username;
  @Value("${spacex.db.password}")
  private String password;

  public DatabaseConfig() {
    // 手动关闭JPA验证，防止重复验证
    System.setProperty("spring.jpa.properties.javax.persistence.validation.mode", "none");
  }

  @Bean
  public DataSource dataSource() throws SQLException {
    DruidDataSource dataSource = new DruidDataSource();
    dataSource.setUrl(url);
    dataSource.setUsername(username);
    dataSource.setPassword(password);
    dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
    dataSource.setInitialSize(5);
    dataSource.setMinIdle(5);
    dataSource.setMaxActive(20);
    dataSource.setMaxWait(60000);
    dataSource.setTimeBetweenEvictionRunsMillis(60000);
    dataSource.setMinEvictableIdleTimeMillis(300000);
    dataSource.setValidationQuery("SELECT 1");
    dataSource.setTestWhileIdle(true);
    dataSource.setTestOnBorrow(false);
    dataSource.setTestOnReturn(false);
    dataSource.setPoolPreparedStatements(true);
    dataSource.setMaxPoolPreparedStatementPerConnectionSize(20);
    dataSource.setFilters("stat,wall,slf4j");
    return dataSource;
  }

}
