/*
 * Decompiled with CFR 0.152.
 */
package io.v47.tmdb.autoconfigure;

import io.v47.tmdb.TmdbClient;
import io.v47.tmdb.api.key.TmdbApiKeyProvider;
import io.v47.tmdb.autoconfigure.TmdbAutoConfigurationCondition;
import io.v47.tmdb.http.ContextWebClientFactory;
import io.v47.tmdb.http.HttpClientFactory;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={TmdbAutoConfigurationCondition.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0017\u00a8\u0006\u000e"}, d2={"Lio/v47/tmdb/autoconfigure/TmdbAutoConfiguration;", "", "()V", "apiKeyProvider", "Lio/v47/tmdb/api/key/TmdbApiKeyProvider;", "apiKey", "", "contextWebClientFactory", "Lio/v47/tmdb/http/HttpClientFactory;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "tmdbClient", "Lio/v47/tmdb/TmdbClient;", "httpClientFactory", "spring-boot-starter"})
public class TmdbAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={HttpClientFactory.class})
    @NotNull
    public HttpClientFactory contextWebClientFactory(@NotNull ApplicationContext applicationContext) {
        return (HttpClientFactory)new ContextWebClientFactory(applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={TmdbApiKeyProvider.class})
    @ConditionalOnExpression(value="'${tmdb-client.api-key:#{systemEnvironment['TMDB_API_KEY']}}'!=''")
    @NotNull
    public TmdbApiKeyProvider apiKeyProvider(@Value(value="${tmdb-client.api-key:#{systemEnvironment['TMDB_API_KEY']}}") @NotNull String apiKey) {
        return () -> TmdbAutoConfiguration.apiKeyProvider$lambda$0(apiKey);
    }

    @Bean
    @ConditionalOnMissingBean(value={TmdbClient.class})
    @NotNull
    public TmdbClient tmdbClient(@NotNull HttpClientFactory httpClientFactory, @NotNull TmdbApiKeyProvider apiKeyProvider) {
        return new TmdbClient(httpClientFactory, apiKeyProvider);
    }

    private static final String apiKeyProvider$lambda$0(String $apiKey) {
        return $apiKey;
    }
}

