/**
 * vertigo - simple java starter
 *
 * Copyright (C) 2013, KleeGroup, direction.technique@kleegroup.com (http://www.kleegroup.com)
 * KleeGroup, Centre d'affaire la Boursidiere - BP 159 - 92357 Le Plessis Robinson Cedex - France
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.vertigo.commons.parser;

import io.vertigo.core.lang.Assertion;

/**
 * Enlève les blancs et les commentaires
 * Cette règle ne plante jamais -sauf si un blanc obligatoire n'est pas présent-
 * mais permet de faire avancer l'index.
 * @author pchretien
 */
public final class WhiteSpaceRule implements Rule<Void>, Parser<Void> {
	private final Rule<String> rule;

	/**
	 * Constructeur.
	 * @param blanks Caractères "blancs" et commentaires.
	 */
	public WhiteSpaceRule(final String blanks) {
		super();
		Assertion.checkNotNull(blanks);
		//----------------------------------------------------------------------
		rule = new WordRule(true, blanks, WordRule.Mode.ACCEPT);
	}

	/** {@inheritDoc} */
	@Override
	public String getExpression() {
		return "blanks";
	}

	public Parser<Void> createParser() {
		return this;
	}

	/** {@inheritDoc} */
	public int parse(final String text, final int start) throws NotFoundException {
		int lastIndex;
		int index = start;
		index = rule.createParser().parse(text, index);

		//Suppression des commentaires  /*xxxxxxxxxxxxxxx*/
		while (text.length() > index + 2 && text.substring(index, index + 2).equals("/*")) {
			//final int startComment = index;
			index += 2;
			lastIndex = index;
			index = text.indexOf("*/", index);
			if (index < 0) {
				//throw new NotFoundException(text, startComment, null, "Fermeture des commentaires */ non trouvée");
				throw new NotFoundException(text, lastIndex, null, "Fermeture des commentaires */ non trouvée");
			}
			index += 2;
			//On supprime les blancs
			index = rule.createParser().parse(text, index);
		}
		return index;
	}

	public Void get() {
		return null;
	}

}
