/**
 * vertigo - simple java starter
 *
 * Copyright (C) 2013, KleeGroup, direction.technique@kleegroup.com (http://www.kleegroup.com)
 * KleeGroup, Centre d'affaire la Boursidiere - BP 159 - 92357 Le Plessis Robinson Cedex - France
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.vertigo.dynamo.domain.metamodel.association;

import io.vertigo.core.lang.Assertion;

/**
 * Définition d'une association NN.
 * @author  jcassignol, pchretien
 */
public final class AssociationNNDefinition extends AssociationDefinition {
	private final String tableName;

	/**
	 * Constructeur d'une association n-n.
	 * @param tableName Nom de la table
	 * @param associationNodeA Noeud A
	 * @param associationNodeB Noeud B
	 */
	public AssociationNNDefinition(final String name, final String tableName, final AssociationNode associationNodeA, final AssociationNode associationNodeB) {
		super(name, associationNodeA, associationNodeB);
		//----------------------------------------------------------------------
		Assertion.checkNotNull(tableName);
		this.tableName = tableName;
	}

	//==========================================================================
	/**
	 * @return Nom de la table porteuse de la relation NN
	 */
	public String getTableName() {
		return tableName;
	}

	/** {@inheritDoc} */
	@Override
	public boolean isAssociationSimpleDefinition() {
		return false;
	}

	/** {@inheritDoc} */
	@Override
	public AssociationSimpleDefinition castAsAssociationSimpleDefinition() {
		throw new IllegalAccessError("Il ne s'agit pas d'une relation simple");
	}

	/** {@inheritDoc} */
	@Override
	public AssociationNNDefinition castAsAssociationNNDefinition() {
		return this;
	}
}
