/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.vertx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.dynjs.runtime.DynJS;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.InitializationListener;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.Runner;
import org.vertx.java.platform.Verticle;

public class DynJSVerticle
extends Verticle {
    private final DynJS runtime;
    private final String scriptName;
    protected Object stopFunction;
    protected ExecutionContext rootContext;

    public DynJSVerticle(DynJS runtime, String scriptName) {
        this.runtime = runtime;
        this.scriptName = scriptName;
    }

    protected ExecutionContext initializeRootContext() {
        return ExecutionContext.createGlobalExecutionContext((DynJS)this.runtime, (InitializationListener)new InitializationListener(){

            public void initialize(ExecutionContext context) {
                DynJSVerticle.this.rootContext = context;
            }
        });
    }

    protected DynJS getRuntime() {
        return this.runtime;
    }

    protected String getScriptName() {
        return this.scriptName;
    }

    public void start() {
        File scriptFile = new File(this.scriptName);
        this.rootContext = this.initializeRootContext();
        Runner runner = this.runtime.newRunner();
        try {
            if (scriptFile.exists()) {
                runner.withContext(this.rootContext).withSource(scriptFile).evaluate();
            } else {
                InputStream is = this.runtime.getConfig().getClassLoader().getResourceAsStream(this.scriptName);
                if (is == null) {
                    throw new FileNotFoundException("Cannot find script: " + this.scriptName);
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                runner.withContext(this.rootContext).withSource((Reader)reader).evaluate();
                this.stopFunction = runner.withContext(this.rootContext).withSource("(typeof vertxStop == 'function' ? vertxStop : null)").evaluate();
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        catch (Exception e) {
            System.err.println("Error loading script: " + this.scriptName + ". " + e.getLocalizedMessage());
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.stopFunction instanceof JSFunction) {
                ((JSFunction)this.stopFunction).call(this.rootContext);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

