/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.page.InterpretedPage;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.vfs.StdoutStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.StringPath;
import io.vertx.lang.php.Vertx;
import io.vertx.lang.php.buffer.Buffer;
import io.vertx.lang.php.eventbus.ReplyException;
import io.vertx.lang.php.eventbus.ReplyFailure;
import io.vertx.lang.php.http.HttpClient;
import io.vertx.lang.php.http.HttpServer;
import io.vertx.lang.php.http.RouteMatcher;
import io.vertx.lang.php.net.NetClient;
import io.vertx.lang.php.net.NetServer;
import io.vertx.lang.php.net.NetSocket;
import io.vertx.lang.php.parsetools.RecordParser;
import io.vertx.lang.php.streams.Pump;
import io.vertx.lang.php.streams.ReadStream;
import io.vertx.lang.php.streams.WriteStream;
import io.vertx.lang.php.streams.impl.InstantWriteStream;
import io.vertx.lang.php.testtools.PhpTestCase;
import io.vertx.lang.php.testtools.PhpTestRunner;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.vertx.java.core.VertxException;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.platform.Container;
import org.vertx.java.platform.Verticle;
import org.vertx.java.platform.VerticleFactory;

public class PhpVerticleFactory
implements VerticleFactory {
    private ClassLoader cl;
    public static org.vertx.java.core.Vertx vertx;
    public static Container container;
    public QuercusContext context = null;

    public void init(org.vertx.java.core.Vertx vertx, Container container, ClassLoader cl) {
        this.cl = cl;
        PhpVerticleFactory.vertx = vertx;
        PhpVerticleFactory.container = container;
    }

    protected void initQuercusContext() {
        if (this.context != null) {
            return;
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.cl);
            this.context = new QuercusContext();
            this.context.setIni("error_reporting", "0");
            this.context.addJavaClass("Vertx", Vertx.class);
            this.context.addJavaClass("Vertx\\EventBus\\ReplyException", ReplyException.class);
            this.context.addJavaClass("Vertx\\EventBus\\ReplyFailure", ReplyFailure.class);
            this.context.addJavaClass("Vertx\\Http\\HttpServer", HttpServer.class);
            this.context.addJavaClass("Vertx\\Http\\HttpClient", HttpClient.class);
            this.context.addJavaClass("Vertx\\Http\\RouteMatcher", RouteMatcher.class);
            this.context.addJavaClass("Vertx\\Net\\NetServer", NetServer.class);
            this.context.addJavaClass("Vertx\\Net\\NetClient", NetClient.class);
            this.context.addJavaClass("Vertx\\Net\\NetSocket", NetSocket.class);
            this.context.addJavaClass("Vertx\\Buffer", Buffer.class);
            this.context.addJavaClass("Vertx\\Logger", Logger.class);
            this.context.addJavaClass("Vertx\\Pump", Pump.class);
            this.context.addJavaClass("Vertx\\ParseTools\\RecordParser", RecordParser.class);
            this.context.addJavaClass("Vertx\\ReadStream", ReadStream.class);
            this.context.addJavaClass("Vertx\\WriteStream", WriteStream.class);
            this.context.addJavaClass("Vertx\\VertxException", VertxException.class);
            this.context.addJavaClass("Vertx\\Test\\TestRunner", PhpTestRunner.class);
            this.context.addJavaClass("Vertx\\Test\\PhpTestCase", PhpTestCase.class);
            this.context.init();
            this.context.start();
            this.addRequireVertxToContext();
            this.context.start();
            AbstractFunction func = this.context.findFunction(this.context.createString("phpinfo"));
            if (func == null) {
                this.context = null;
                throw new VertxException("PHP Environment didn't load properly");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void addRequireVertxToContext() {
        this.context.setFunction(this.context.createString("require_vertx"), new AbstractFunction(){
            private static final long serialVersionUID = 5350698219672910902L;

            public Value call(Env env, Value[] args) {
                if (args.length != 1) {
                    throw new IllegalArgumentException("require_vertx: missing Argument path");
                }
                String resourceName = args[0].toString();
                URL resourcePath = PhpVerticleFactory.this.cl.getResource(args[0].toString());
                try {
                    String script = String.format("require('%s');", resourcePath.toString());
                    QuercusProgram program = PhpVerticleFactory.this.context.parseCode(PhpVerticleFactory.this.context.createString(script));
                    program.execute(env);
                }
                catch (NullPointerException np) {
                    if (Vertx.logger() == null) {
                        System.out.println(String.format("Could not find Vertx resource '%s''", resourceName));
                    } else {
                        Vertx.logger().error((Object)String.format("Could not find Vertx resource '%s''", resourceName));
                    }
                    np.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return NullValue.create();
            }
        });
    }

    public QuercusContext getQuercusContext() {
        return this.context;
    }

    public Verticle createVerticle(String main) throws Exception {
        String scriptPath;
        if (this.context == null) {
            this.initQuercusContext();
        }
        if ((scriptPath = this.findScript(main)) == null) {
            throw new VertxException(String.format("%s is not a valid PHP verticle.", main));
        }
        return new PhpVerticle(this.context, scriptPath);
    }

    private String findScript(String script) {
        File scriptFile;
        URL filename = this.cl.getResource(script);
        if (filename != null && (scriptFile = new File(filename.getPath())).exists()) {
            return scriptFile.toPath().toString();
        }
        return null;
    }

    public void reportException(Logger logger, Throwable t) {
        if (t instanceof QuercusException) {
            Env env = Env.getCurrent();
            Location location = env.getLocation();
            logger.error((Object)"\nAn exception occured in a PHP verticle.");
            String className = location.getClassName();
            String funcName = location.getFunctionName();
            if (funcName != null && funcName != "NULL" && !funcName.startsWith("__quercus_")) {
                if (className != "NULL" && funcName != "NULL" && !funcName.startsWith("__quercus_")) {
                    logger.error((Object)String.format("%s in %s on line %d in %s::%s()", t.getMessage(), location.getFileName(), location.getLineNumber(), className, funcName));
                } else {
                    logger.error((Object)String.format("%s in %s on line %d in %s()", t.getMessage(), location.getFileName(), location.getLineNumber(), funcName));
                }
            } else {
                logger.error((Object)String.format("%s in %s on line %d", t.getMessage(), location.getFileName(), location.getLineNumber()));
            }
        } else {
            t.printStackTrace();
        }
    }

    public void close() {
        AbstractFunction function = this.context.findFunction(StringValue.create((String)"vertx_stop").toStringValue());
        if (function != null) {
            function.call(Env.getCurrent());
        }
        this.context.close();
        this.context = null;
    }

    public void finalize() {
        this.close();
    }

    private class PhpVerticle
    extends Verticle {
        private final String scriptName;
        private final QuercusContext context;
        private com.caucho.vfs.WriteStream out;
        private Env globalEnv;

        PhpVerticle(QuercusContext context, String script) {
            this.scriptName = script;
            this.context = context;
        }

        public void start() {
            String classLoaderScript = "spl_autoload_register(function($class) {require_vertx(str_replace('\\\\', '/', $class) . '.php');});";
            String script = String.format("<?php " + classLoaderScript + "require '%s'; ?>", this.scriptName);
            try (com.caucho.vfs.ReadStream reader = new StringPath(script).openRead();){
                QuercusProgram program = QuercusParser.parse((QuercusContext)this.context, null, (com.caucho.vfs.ReadStream)reader);
                InterpretedPage page = new InterpretedPage(program);
                this.out = new InstantWriteStream((StreamImpl)StdoutStream.create());
                this.globalEnv = new Env(this.context, (QuercusPage)page, this.out, null, null);
                this.globalEnv.start();
                program.execute(this.globalEnv);
                this.out.flush();
            }
            catch (IOException e) {
                throw new VertxException("Cannot parse PHP verticle: " + this.scriptName);
            }
            catch (Exception e) {
                throw new VertxException((Throwable)e);
            }
        }

        public void stop() {
            this.globalEnv = null;
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    throw new VertxException((Throwable)e);
                }
                this.out = null;
            }
        }

        public void finalize() {
            this.stop();
        }
    }
}

