/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.Gettable;
import io.vertx.lang.php.Settable;
import io.vertx.lang.php.util.PhpTypes;
import org.vertx.java.core.ClientSSLSupport;
import org.vertx.java.core.SSLSupport;
import org.vertx.java.core.TCPSupport;

public abstract class TCPClient<T extends TCPSupport<T> & ClientSSLSupport<T>>
implements Gettable,
Settable {
    protected T client;

    public TCPClient(T client) {
        this.client = client;
    }

    @Override
    public Value __getField(Env env, StringValue name) {
        return env.wrapJava((Object)this).callMethod(env, name);
    }

    @Override
    public void __setField(Env env, StringValue name, Value value) {
        env.wrapJava((Object)this).callMethod(env, name, value);
    }

    public BooleanValue trustAll(Env env) {
        return BooleanValue.create((boolean)((ClientSSLSupport)this.client).isTrustAll());
    }

    public TCPClient<T> trustAll(Env env, BooleanValue trustAll) {
        PhpTypes.assertNotNull(env, (Value)trustAll, "Value to %s::trustAll() must be a boolean.", this.toString());
        ((ClientSSLSupport)this.client).setTrustAll(trustAll.toBoolean());
        return this;
    }

    public BooleanValue ssl(Env env) {
        return BooleanValue.create((boolean)((SSLSupport)this.client).isSSL());
    }

    public TCPClient<T> ssl(Env env, BooleanValue ssl) {
        PhpTypes.assertNotNull(env, (Value)ssl, "Value to %s::ssl() must be a boolean.", this.toString());
        ((SSLSupport)this.client).setSSL(ssl.toBoolean());
        return this;
    }

    public StringValue keyStorePassword(Env env) {
        return env.createString(((SSLSupport)this.client).getKeyStorePassword());
    }

    public TCPClient<T> keyStorePassword(Env env, StringValue pwd) {
        PhpTypes.assertNotNull(env, (Value)pwd, "Password to %s::keyStorePassword() must be a string.", this.toString());
        ((SSLSupport)this.client).setKeyStorePassword(pwd.toString());
        return this;
    }

    public StringValue keyStorePath(Env env) {
        return env.createString(((SSLSupport)this.client).getKeyStorePath());
    }

    public TCPClient<T> keyStorePath(Env env, StringValue path) {
        PhpTypes.assertNotNull(env, (Value)path, "Path to %s::keyStorePath() must be a string.", this.toString());
        ((SSLSupport)this.client).setKeyStorePath(path.toString());
        return this;
    }

    public StringValue trustStorePath(Env env) {
        return env.createString(((SSLSupport)this.client).getTrustStorePath());
    }

    public TCPClient<T> trustStorePath(Env env, StringValue pwd) {
        ((SSLSupport)this.client).setTrustStorePath(pwd.toString());
        return this;
    }

    public StringValue trustStorePassword(Env env) {
        return env.createString(((SSLSupport)this.client).getTrustStorePassword());
    }

    public TCPClient<T> trustStorePassword(Env env, StringValue pwd) {
        PhpTypes.assertNotNull(env, (Value)pwd, "Password to %s::trustStorePassword() must be a string.", this.toString());
        ((SSLSupport)this.client).setTrustStorePassword(pwd.toString());
        return this;
    }

    public Value sendBufferSize(Env env) {
        return env.wrapJava((Object)this.client.getSendBufferSize());
    }

    public TCPClient<T> sendBufferSize(Env env, NumberValue size) {
        PhpTypes.assertNotNull(env, (Value)size, "Size to %s::sendBufferSize() must be a number.", this.toString());
        this.client.setSendBufferSize(size.toInt());
        return this;
    }

    public Value receiveBufferSize(Env env) {
        return env.wrapJava((Object)this.client.getReceiveBufferSize());
    }

    public TCPClient<T> receiveBufferSize(Env env, NumberValue size) {
        PhpTypes.assertNotNull(env, (Value)size, "Size to %s::receiveBufferSize() must be a number.", this.toString());
        this.client.setReceiveBufferSize(size.toInt());
        return this;
    }

    public BooleanValue reuseAddress(Env env) {
        return BooleanValue.create((boolean)this.client.isReuseAddress());
    }

    public TCPClient<T> reuseAddress(Env env, BooleanValue reuse) {
        PhpTypes.assertNotNull(env, (Value)reuse, "Value to %s::reuseAddress() must be a boolean.", this.toString());
        this.client.setReuseAddress(reuse.toBoolean());
        return this;
    }

    public Value soLinger(Env env) {
        return env.wrapJava((Object)this.client.getSoLinger());
    }

    public TCPClient<T> soLinger(Env env, NumberValue linger) {
        PhpTypes.assertNotNull(env, (Value)linger, "Value to %s::soLinger() must be a number.", this.toString());
        this.client.setReceiveBufferSize(linger.toInt());
        return this;
    }

    public BooleanValue keepAlive(Env env) {
        return BooleanValue.create((boolean)this.client.isTCPKeepAlive());
    }

    public TCPClient<T> keepAlive(Env env, BooleanValue keepAlive) {
        PhpTypes.assertNotNull(env, (Value)keepAlive, "Value to %s::keepAlive() must be a boolean.", this.toString());
        this.client.setTCPKeepAlive(keepAlive.toBoolean());
        return this;
    }

    public BooleanValue noDelay(Env env) {
        return BooleanValue.create((boolean)this.client.isTCPNoDelay());
    }

    public TCPClient<T> noDelay(Env env, BooleanValue tcpNoDelay) {
        PhpTypes.assertNotNull(env, (Value)tcpNoDelay, "Value to %s::noDelay() must be a boolean.", this.toString());
        this.client.setTCPNoDelay(tcpNoDelay.toBoolean());
        return this;
    }

    public Value trafficClass(Env env) {
        return env.wrapJava((Object)this.client.getTrafficClass());
    }

    public TCPClient<T> trafficClass(Env env, NumberValue trafficClass) {
        PhpTypes.assertNotNull(env, (Value)trafficClass, "Value to %s::trafficClass() must be a number.", this.toString());
        this.client.setTrafficClass(trafficClass.toInt());
        return this;
    }

    public BooleanValue usePooledBuffers(Env env) {
        return BooleanValue.create((boolean)this.client.isUsePooledBuffers());
    }

    public TCPClient<T> usePooledBuffers(Env env, BooleanValue pooledBuffers) {
        PhpTypes.assertNotNull(env, (Value)pooledBuffers, "Value to %s::usePooledBuffers() must be a boolean.", this.toString());
        this.client.setUsePooledBuffers(pooledBuffers.toBoolean());
        return this;
    }

    public String toString() {
        return "php:Vertx\\TCPClient";
    }
}

