/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.Gettable;
import io.vertx.lang.php.Settable;
import org.vertx.java.core.SSLSupport;
import org.vertx.java.core.ServerSSLSupport;
import org.vertx.java.core.ServerTCPSupport;

public abstract class TCPServer<T extends ServerTCPSupport<T> & ServerSSLSupport<T>>
implements Gettable,
Settable {
    protected T server;

    public TCPServer(T server) {
        this.server = server;
    }

    @Override
    public Value __getField(Env env, StringValue name) {
        return env.wrapJava((Object)this).callMethod(env, name);
    }

    @Override
    public void __setField(Env env, StringValue name, Value value) {
        env.wrapJava((Object)this).callMethod(env, name, value);
    }

    public Value acceptBacklog(Env env) {
        return env.wrapJava((Object)this.server.getAcceptBacklog());
    }

    public TCPServer<T> acceptBacklog(Env env, NumberValue backlog) {
        this.server.setAcceptBacklog(backlog.toInt());
        return this;
    }

    public BooleanValue clientAuthRequired(Env env) {
        return BooleanValue.create((boolean)((ServerSSLSupport)this.server).isClientAuthRequired());
    }

    public TCPServer<?> clientAuthRequired(Env env, BooleanValue required) {
        ((ServerSSLSupport)this.server).setClientAuthRequired(required.toBoolean());
        return this;
    }

    public BooleanValue ssl(Env env) {
        return BooleanValue.create((boolean)((SSLSupport)this.server).isSSL());
    }

    public TCPServer<?> ssl(Env env, BooleanValue ssl) {
        ((SSLSupport)this.server).setSSL(ssl.toBoolean());
        return this;
    }

    public StringValue keyStorePassword(Env env) {
        return env.createString(((SSLSupport)this.server).getKeyStorePassword());
    }

    public TCPServer<T> keyStorePassword(Env env, StringValue pwd) {
        ((SSLSupport)this.server).setKeyStorePassword(pwd.toString());
        return this;
    }

    public StringValue keyStorePath(Env env) {
        return env.createString(((SSLSupport)this.server).getKeyStorePath());
    }

    public TCPServer<T> keyStorePath(Env env, StringValue pwd) {
        ((SSLSupport)this.server).setKeyStorePath(pwd.toString());
        return this;
    }

    public StringValue trustStorePassword(Env env) {
        return env.createString(((SSLSupport)this.server).getTrustStorePassword());
    }

    public TCPServer<T> trustStorePassword(Env env, StringValue pwd) {
        ((SSLSupport)this.server).setTrustStorePassword(pwd.toString());
        return this;
    }

    public StringValue trustStorePath(Env env) {
        return env.createString(((SSLSupport)this.server).getTrustStorePath());
    }

    public TCPServer<T> trustStorePath(Env env, StringValue pwd) {
        ((SSLSupport)this.server).setTrustStorePath(pwd.toString());
        return this;
    }

    public Value sendBufferSize(Env env) {
        return env.wrapJava((Object)this.server.getSendBufferSize());
    }

    public TCPServer<T> sendBufferSize(Env env, NumberValue size) {
        this.server.setSendBufferSize(size.toInt());
        return this;
    }

    public Value receiveBufferSize(Env env) {
        return env.wrapJava((Object)this.server.getReceiveBufferSize());
    }

    public TCPServer<T> receiveBufferSize(Env env, NumberValue size) {
        this.server.setReceiveBufferSize(size.toInt());
        return this;
    }

    public BooleanValue reuseAddress(Env env) {
        return BooleanValue.create((boolean)this.server.isReuseAddress());
    }

    public TCPServer<?> reuseAddress(Env env, BooleanValue reuseAddress) {
        this.server.setReuseAddress(reuseAddress.toBoolean());
        return this;
    }

    public Value soLinger(Env env) {
        return env.wrapJava((Object)this.server.getSoLinger());
    }

    public TCPServer<T> soLinger(Env env, NumberValue soLinger) {
        this.server.setSoLinger(soLinger.toInt());
        return this;
    }

    public BooleanValue keepAlive(Env env) {
        return BooleanValue.create((boolean)this.server.isTCPKeepAlive());
    }

    public TCPServer<?> keepAlive(Env env, BooleanValue keepAlive) {
        this.server.setTCPKeepAlive(keepAlive.toBoolean());
        return this;
    }

    public BooleanValue noDelay(Env env) {
        return BooleanValue.create((boolean)this.server.isTCPNoDelay());
    }

    public TCPServer<?> noDelay(Env env, BooleanValue noDelay) {
        this.server.setTCPNoDelay(noDelay.toBoolean());
        return this;
    }

    public Value trafficClass(Env env) {
        return env.wrapJava((Object)this.server.getTrafficClass());
    }

    public TCPServer<T> trafficClass(Env env, NumberValue trafficClass) {
        this.server.setTrafficClass(trafficClass.toInt());
        return this;
    }

    public BooleanValue usePooledBuffers(Env env) {
        return BooleanValue.create((boolean)this.server.isUsePooledBuffers());
    }

    public TCPServer<?> usePooledBuffers(Env env, BooleanValue usePooledBuffers) {
        this.server.setUsePooledBuffers(usePooledBuffers.toBoolean());
        return this;
    }

    public String toString() {
        return "php:Vertx\\TCPServer";
    }
}

