/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.Context;
import io.vertx.lang.php.PhpVerticleFactory;
import io.vertx.lang.php.eventbus.EventBus;
import io.vertx.lang.php.file.FileSystem;
import io.vertx.lang.php.http.HttpClient;
import io.vertx.lang.php.http.HttpServer;
import io.vertx.lang.php.net.NetClient;
import io.vertx.lang.php.net.NetServer;
import io.vertx.lang.php.shareddata.SharedData;
import io.vertx.lang.php.sockjs.SockJSServer;
import io.vertx.lang.php.util.HandlerFactory;
import io.vertx.lang.php.util.PhpTypes;
import java.util.Map;
import org.vertx.java.core.logging.Logger;

public final class Vertx {
    public static NetServer createNetServer(Env env) {
        return new NetServer(PhpVerticleFactory.vertx.createNetServer());
    }

    public static NetClient createNetClient(Env env) {
        return new NetClient(PhpVerticleFactory.vertx.createNetClient());
    }

    public static HttpServer createHttpServer(Env env) {
        return new HttpServer(PhpVerticleFactory.vertx.createHttpServer());
    }

    public static HttpClient createHttpClient(Env env) {
        return new HttpClient(PhpVerticleFactory.vertx.createHttpClient());
    }

    public static SockJSServer createSockJSServer(Env env, HttpServer server) {
        return new SockJSServer(PhpVerticleFactory.vertx.createSockJSServer(server.getVertxServer()));
    }

    public static BooleanValue isEventLoop(Env env) {
        return BooleanValue.create((boolean)PhpVerticleFactory.vertx.isEventLoop());
    }

    public static BooleanValue isWorker(Env env) {
        return BooleanValue.create((boolean)PhpVerticleFactory.vertx.isWorker());
    }

    public static EventBus eventBus(Env env) {
        return new EventBus(PhpVerticleFactory.vertx.eventBus());
    }

    public static FileSystem fileSystem(Env env) {
        return new FileSystem(PhpVerticleFactory.vertx.fileSystem());
    }

    public static SharedData sharedData(Env env) {
        return new SharedData(PhpVerticleFactory.vertx.sharedData());
    }

    public static Context currentContext(Env env) {
        return new Context(PhpVerticleFactory.vertx.currentContext());
    }

    public static void runOnContext(Env env, Value handler) {
        Vertx.currentContext(env).runOnContext(env, handler);
    }

    public static LongValue setTimer(Env env, LongValue delay, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx::runOnContext() must be callable.", new Object[0]);
        PhpVerticleFactory.vertx.setTimer(delay.toLong(), HandlerFactory.createGenericHandler(env, handler));
        return delay;
    }

    public static LongValue setPeriodic(Env env, LongValue delay, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx::runOnContext() must be callable.", new Object[0]);
        PhpVerticleFactory.vertx.setPeriodic(delay.toLong(), HandlerFactory.createGenericHandler(env, handler));
        return delay;
    }

    public static BooleanValue cancelTimer(Env env, LongValue id) {
        boolean result = PhpVerticleFactory.vertx.cancelTimer(id.toLong());
        return BooleanValue.create((boolean)result);
    }

    public static void stop(Env env) {
        PhpVerticleFactory.vertx.stop();
    }

    public static void deployModule(Env env, StringValue moduleName, @Optional ArrayValue config, @Optional(value="1") NumberValue instances, @Optional Value handler) {
        boolean hasConfig = PhpTypes.notNull((Value)config);
        boolean hasHandler = PhpTypes.notNull(handler);
        if (hasConfig && hasHandler) {
            PhpTypes.assertCallable(env, handler, "Handler argument to Vertx::deployModule() must be callable.", new Object[0]);
            PhpVerticleFactory.container.deployModule(moduleName.toString(), PhpTypes.arrayToJson(env, (Value)config), instances.toInt(), HandlerFactory.createAsyncGenericHandler(env, handler));
        } else if (hasConfig) {
            PhpVerticleFactory.container.deployModule(moduleName.toString(), PhpTypes.arrayToJson(env, (Value)config), instances.toInt());
        } else if (hasHandler) {
            PhpTypes.assertCallable(env, handler, "Handler argument to Vertx::deployModule() must be callable.", new Object[0]);
            PhpVerticleFactory.container.deployModule(moduleName.toString(), instances.toInt(), HandlerFactory.createAsyncGenericHandler(env, handler));
        } else {
            PhpVerticleFactory.container.deployModule(moduleName.toString(), instances.toInt());
        }
    }

    public static void undeployModule(Env env, StringValue deploymentID, @Optional Value handler) {
        if (PhpTypes.notNull(handler)) {
            PhpTypes.assertCallable(env, handler, "Handler argument to Vertx::undeployModule() must be callable.", new Object[0]);
            PhpVerticleFactory.container.undeployModule(deploymentID.toString(), HandlerFactory.createAsyncVoidHandler(env, handler));
        } else {
            PhpVerticleFactory.container.undeployModule(deploymentID.toString());
        }
    }

    public static void deployVerticle(Env env, StringValue main, @Optional ArrayValue config, @Optional(value="1") NumberValue instances, @Optional Value handler) {
        boolean hasConfig = PhpTypes.notNull((Value)config);
        boolean hasHandler = PhpTypes.notNull(handler);
        if (hasConfig && hasHandler) {
            PhpTypes.assertCallable(env, handler, "Handler argument to Vertx::deployVerticle() must be callable.", new Object[0]);
            PhpVerticleFactory.container.deployVerticle(main.toString(), PhpTypes.arrayToJson(env, (Value)config), instances.toInt(), HandlerFactory.createAsyncGenericHandler(env, handler));
        } else if (hasConfig) {
            PhpVerticleFactory.container.deployVerticle(main.toString(), PhpTypes.arrayToJson(env, (Value)config), instances.toInt());
        } else if (hasHandler) {
            PhpTypes.assertCallable(env, handler, "Handler argument to Vertx::deployVerticle() must be callable.", new Object[0]);
            PhpVerticleFactory.container.deployVerticle(main.toString(), instances.toInt(), HandlerFactory.createAsyncGenericHandler(env, handler));
        } else {
            PhpVerticleFactory.container.deployVerticle(main.toString(), instances.toInt());
        }
    }

    public static void undeployVerticle(Env env, StringValue deploymentID, @Optional Value handler) {
        if (PhpTypes.notNull(handler)) {
            PhpTypes.assertCallable(env, handler, "Handler argument to Vertx::undeployVerticle() must be callable.", new Object[0]);
            PhpVerticleFactory.container.undeployVerticle(deploymentID.toString(), HandlerFactory.createAsyncVoidHandler(env, handler));
        } else {
            PhpVerticleFactory.container.undeployVerticle(deploymentID.toString());
        }
    }

    public static void deployWorkerVerticle(Env env, StringValue main, @Optional ArrayValue config, @Optional(value="1") NumberValue instances) {
        boolean hasConfig;
        boolean bl = hasConfig = config != null && !config.isDefault();
        if (hasConfig) {
            PhpVerticleFactory.container.deployWorkerVerticle(main.toString(), PhpTypes.arrayToJson(env, (Value)config), instances.toInt());
        } else {
            PhpVerticleFactory.container.deployWorkerVerticle(main.toString(), instances.toInt());
        }
    }

    public static ArrayValue env(Env env) {
        Map map = PhpVerticleFactory.container.env();
        ArrayValueImpl array = new ArrayValueImpl();
        for (Map.Entry entry : map.entrySet()) {
            array.append((Value)env.createString((String)entry.getKey()), (Value)env.createString((String)entry.getValue()));
        }
        return array;
    }

    public static void exit() {
        PhpVerticleFactory.container.exit();
    }

    public static Logger logger() {
        return PhpVerticleFactory.container.logger();
    }

    public static ArrayValue config(Env env) {
        return PhpTypes.arrayFromJson(env, PhpVerticleFactory.container.config());
    }

    public String toString() {
        return "php:Vertx";
    }
}

