/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.buffer;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.spl.ArrayAccess;
import com.caucho.quercus.lib.spl.Countable;
import io.vertx.lang.php.Gettable;
import io.vertx.lang.php.util.PhpTypes;
import java.util.Arrays;

public class Buffer
implements ArrayAccess,
Countable,
Gettable {
    private org.vertx.java.core.buffer.Buffer buffer;
    private static final String[] properties = new String[]{"length"};

    public Buffer() {
        this.buffer = new org.vertx.java.core.buffer.Buffer();
    }

    public Buffer(Env env) {
        this.buffer = new org.vertx.java.core.buffer.Buffer();
    }

    public Buffer(org.vertx.java.core.buffer.Buffer buffer) {
        this.buffer = buffer;
    }

    public Buffer(Env env, Value value) {
        this.buffer = new org.vertx.java.core.buffer.Buffer(value.toString());
    }

    @Override
    public Value __getField(Env env, StringValue name) {
        if (Arrays.asList(properties).contains(name.toString())) {
            return env.wrapJava((Object)this).callMethod(env, name);
        }
        return null;
    }

    public Value getByte(Env env, NumberValue pos) {
        return env.wrapJava((Object)this.buffer.getByte(pos.toInt()));
    }

    public Buffer setByte(Env env, NumberValue pos, Value value) {
        this.buffer.setByte(pos.toInt(), value.toJavaByte().byteValue());
        return this;
    }

    public Buffer appendByte(Env env, Value value) {
        this.buffer.appendByte(value.toJavaByte().byteValue());
        return this;
    }

    public double getDouble(Env env, NumberValue pos) {
        return this.buffer.getDouble(pos.toInt());
    }

    public Buffer setDouble(Env env, NumberValue pos, Value value) {
        this.buffer.setDouble(pos.toInt(), value.toDouble());
        return this;
    }

    public Buffer appendDouble(Env env, Value value) {
        this.buffer.appendDouble(value.toDouble());
        return this;
    }

    public float getFloat(Env env, NumberValue pos) {
        return this.buffer.getFloat(pos.toInt());
    }

    public Buffer setFloat(Env env, NumberValue pos, Value value) {
        this.buffer.setFloat(pos.toInt(), value.toJavaFloat().floatValue());
        return this;
    }

    public Buffer appendFloat(Env env, Value value) {
        this.buffer.appendFloat(value.toJavaFloat().floatValue());
        return this;
    }

    public int getInt(Env env, NumberValue pos) {
        return this.buffer.getInt(pos.toInt());
    }

    public Buffer setInt(Env env, NumberValue pos, Value value) {
        this.buffer.setInt(pos.toInt(), value.toInt());
        return this;
    }

    public Buffer appendInt(Env env, Value value) {
        this.buffer.appendInt(value.toInt());
        return this;
    }

    public long getLong(Env env, NumberValue pos) {
        return this.buffer.getLong(pos.toInt());
    }

    public Buffer setLong(Env env, NumberValue pos, Value value) {
        this.buffer.setLong(pos.toInt(), value.toLong());
        return this;
    }

    public Buffer appendLong(Env env, Value value) {
        this.buffer.appendLong(value.toLong());
        return this;
    }

    public short getShort(Env env, NumberValue pos) {
        return this.buffer.getShort(pos.toInt());
    }

    public Buffer setShort(Env env, NumberValue pos, Value value) {
        this.buffer.setShort(pos.toInt(), value.toJavaShort().shortValue());
        return this;
    }

    public Buffer appendShort(Env env, Value value) {
        this.buffer.appendShort(value.toJavaShort().shortValue());
        return this;
    }

    public Value getString(Env env, NumberValue start, NumberValue end) {
        return env.wrapJava((Object)this.buffer.getString(start.toInt(), end.toInt()));
    }

    public Buffer setString(Env env, NumberValue pos, Value value, @Optional Value enc) {
        if (PhpTypes.notNull(enc)) {
            this.buffer.setString(pos.toInt(), value.toString(), enc.toString());
        } else {
            this.buffer.setString(pos.toInt(), value.toString());
        }
        return this;
    }

    public Buffer appendString(Env env, Value value, @Optional Value enc) {
        if (PhpTypes.notNull(enc)) {
            this.buffer.appendString(value.toString(), enc.toString());
        } else {
            this.buffer.appendString(value.toString());
        }
        return this;
    }

    public Buffer getBuffer(Env env, NumberValue start, NumberValue end) {
        return new Buffer(this.buffer.getBuffer(start.toInt(), end.toInt()));
    }

    public Buffer setBuffer(Env env, NumberValue pos, Value value) {
        this.buffer.setBuffer(pos.toInt(), ((Buffer)value.toJavaObject(env, Buffer.class)).__toVertxBuffer());
        return this;
    }

    public Buffer appendBuffer(Env env, Value value) {
        this.buffer.appendBuffer(((Buffer)value.toJavaObject(env, Buffer.class)).__toVertxBuffer());
        return this;
    }

    public Buffer set(Env env, Value pos, Value value) {
        if (value.isLong()) {
            this.buffer.setLong(pos.toInt(), value.toLong());
        } else if (value.isDouble()) {
            this.buffer.setDouble(pos.toInt(), value.toDouble());
        } else if (value.isNumeric()) {
            this.buffer.setInt(pos.toInt(), value.toInt());
        } else if (value.isString()) {
            this.buffer.setString(pos.toInt(), value.toString());
        } else if (value.isObject()) {
            this.buffer.setBuffer(pos.toInt(), ((Buffer)value.toJavaObject(Env.getCurrent(), Buffer.class)).__toVertxBuffer());
        }
        return this;
    }

    public Buffer append(Env env, Value value) {
        if (value.isLong()) {
            this.buffer.appendLong(value.toLong());
        } else if (value.isDouble()) {
            this.buffer.appendDouble(value.toDouble());
        } else if (value.isNumeric()) {
            this.buffer.appendInt(value.toInt());
        } else if (value.isString()) {
            this.buffer.appendString(value.toString());
        } else if (value.isObject()) {
            this.buffer.appendBuffer((org.vertx.java.core.buffer.Buffer)value.toJavaObject(env, org.vertx.java.core.buffer.Buffer.class));
        }
        return this;
    }

    public Value get(Env env, Value pos) {
        return env.wrapJava((Object)this.buffer.getByte(pos.toInt()));
    }

    public boolean offsetExists(Value pos) {
        return this.buffer.length() > pos.toInt();
    }

    public Value offsetGet(Value pos) {
        return this.get(Env.getCurrent(), pos);
    }

    public Value offsetSet(Value pos, Value value) {
        this.set(Env.getCurrent(), pos, value);
        return null;
    }

    public Value offsetUnset(Value pos) {
        return null;
    }

    public int count() {
        return this.buffer.length();
    }

    public int length() {
        return this.buffer.length();
    }

    public Value copy(Env env) {
        return env.wrapJava((Object)new Buffer(this.buffer.copy()));
    }

    public String toString() {
        return this.buffer.toString();
    }

    public Value toString(Env env) {
        return env.wrapJava((Object)this.toString());
    }

    public String __toString() {
        return this.toString();
    }

    public Value toString(Env env, Value enc) {
        if (PhpTypes.isNull(env, enc)) {
            return this.toString(env);
        }
        return env.wrapJava((Object)this.buffer.toString(enc.toString()));
    }

    public org.vertx.java.core.buffer.Buffer __toVertxBuffer() {
        return this.buffer;
    }
}

