/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.eventbus;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.Handler;
import io.vertx.lang.php.ResultModifier;
import io.vertx.lang.php.eventbus.Message;
import io.vertx.lang.php.eventbus.ReplyException;
import io.vertx.lang.php.util.HandlerFactory;
import io.vertx.lang.php.util.PhpTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.buffer.Buffer;

public final class EventBus {
    private org.vertx.java.core.eventbus.EventBus eventBus;
    private static PairRegistry<String, org.vertx.java.core.Handler<org.vertx.java.core.eventbus.Message<Object>>> handlers = new PairRegistry();

    public EventBus(org.vertx.java.core.eventbus.EventBus eventBus) {
        this.eventBus = eventBus;
    }

    private org.vertx.java.core.Handler<org.vertx.java.core.eventbus.Message<Object>> createAddressHandler(Env env, String address, Value callback) {
        return new Handler<org.vertx.java.core.eventbus.Message<Object>>(env, PhpTypes.toCallable(callback), new ResultModifier<org.vertx.java.core.eventbus.Message<Object>, Message<Object>>(){

            @Override
            public Message<Object> modify(org.vertx.java.core.eventbus.Message<Object> message) {
                return new Message<Object>(message);
            }
        });
    }

    public AddressPair<String, org.vertx.java.core.Handler<org.vertx.java.core.eventbus.Message<Object>>> createAddressPair(Env env, StringValue address, Value handler) {
        String realAddress = address.toString();
        org.vertx.java.core.Handler<org.vertx.java.core.eventbus.Message<Object>> realHandler = this.createAddressHandler(env, realAddress, handler);
        return new AddressPair<String, org.vertx.java.core.Handler<org.vertx.java.core.eventbus.Message<Object>>>(realAddress, realHandler);
    }

    public StringValue registerHandler(Env env, StringValue address, Value handler, @Optional Value resultHandler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\EventBus::registerHandler() must be callable.", new Object[0]);
        AddressPair<String, org.vertx.java.core.Handler<org.vertx.java.core.eventbus.Message<Object>>> addressPair = this.createAddressPair(env, address, handler);
        if (PhpTypes.isCallable(env, resultHandler)) {
            org.vertx.java.core.Handler<AsyncResult<Void>> resultEventHandler = HandlerFactory.createAsyncVoidHandler(env, handler);
            this.eventBus.registerHandler(addressPair.getAddress(), addressPair.getHandler(), resultEventHandler);
        } else {
            this.eventBus.registerHandler(addressPair.getAddress(), addressPair.getHandler());
        }
        return env.createString(handlers.register(addressPair).toString());
    }

    public StringValue registerLocalHandler(Env env, StringValue address, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\EventBus::registerLocalHandler() must be callable.", new Object[0]);
        AddressPair<String, org.vertx.java.core.Handler<org.vertx.java.core.eventbus.Message<Object>>> addressPair = this.createAddressPair(env, address, handler);
        this.eventBus.registerLocalHandler(addressPair.getAddress(), addressPair.getHandler());
        return env.createString(handlers.register(addressPair).toString());
    }

    public EventBus unregisterHandler(Env env, Value handlerID) {
        if (handlers.exists(handlerID.toString())) {
            AddressPair<String, org.vertx.java.core.Handler<org.vertx.java.core.eventbus.Message<Object>>> pair = handlers.get(handlerID.toString());
            this.eventBus.unregisterHandler(pair.getAddress(), pair.getHandler());
            handlers.unregister(pair);
        }
        return this;
    }

    public EventBus send(Env env, StringValue address, Value message, @Optional Value handler) {
        boolean hasHandler = false;
        Handler<org.vertx.java.core.eventbus.Message<Object>> sendHandler = null;
        if (PhpTypes.notNull(handler)) {
            PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\EventBus::send() must be callable.", new Object[0]);
            hasHandler = true;
            sendHandler = new Handler<org.vertx.java.core.eventbus.Message<Object>>(env, PhpTypes.toCallable(handler), new ResultModifier<org.vertx.java.core.eventbus.Message<Object>, Message<Object>>(){

                @Override
                public Message<Object> modify(org.vertx.java.core.eventbus.Message<Object> arg) {
                    return new Message<Object>(arg);
                }
            });
        }
        if (message.isBoolean()) {
            if (hasHandler) {
                this.eventBus.send(address.toString(), Boolean.valueOf(message.toBoolean()), sendHandler);
            } else {
                this.eventBus.send(address.toString(), Boolean.valueOf(message.toBoolean()));
            }
        } else if (message.isString()) {
            if (hasHandler) {
                this.eventBus.send(address.toString(), message.toString(), sendHandler);
            } else {
                this.eventBus.send(address.toString(), message.toString());
            }
        } else if (message.isNumeric()) {
            if (hasHandler) {
                this.eventBus.send(address.toString(), Integer.valueOf(message.toInt()), sendHandler);
            } else {
                this.eventBus.send(address.toString(), Integer.valueOf(message.toInt()));
            }
        } else if (message.isObject()) {
            if (hasHandler) {
                this.eventBus.send(address.toString(), (Buffer)message.toJavaObject(env, Buffer.class), sendHandler);
            } else {
                this.eventBus.send(address.toString(), (Buffer)message.toJavaObject(env, Buffer.class));
            }
        } else if (message.isArray()) {
            if (hasHandler) {
                this.eventBus.send(address.toString(), PhpTypes.arrayToJson(env, message), sendHandler);
            } else {
                this.eventBus.send(address.toString(), PhpTypes.arrayToJson(env, message));
            }
        }
        return this;
    }

    public EventBus sendWithTimeout(final Env env, StringValue address, Value message, Value timeout, final Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\EventBus::sendWithTimeout() must be callable.", new Object[0]);
        org.vertx.java.core.Handler<AsyncResult<org.vertx.java.core.eventbus.Message<Object>>> sendHandler = new org.vertx.java.core.Handler<AsyncResult<org.vertx.java.core.eventbus.Message<Object>>>(){

            public void handle(AsyncResult<org.vertx.java.core.eventbus.Message<Object>> result) {
                if (result.failed()) {
                    handler.call(env, env.wrapJava(null), env.wrapJava((Object)new ReplyException((org.vertx.java.core.eventbus.ReplyException)result.cause())));
                } else {
                    handler.call(env, env.wrapJava(new Message((org.vertx.java.core.eventbus.Message)result.result())), env.wrapJava(null));
                }
            }
        };
        if (message.isBoolean()) {
            this.eventBus.sendWithTimeout(address.toString(), Boolean.valueOf(message.toBoolean()), timeout.toLong(), (org.vertx.java.core.Handler)sendHandler);
        } else if (message.isString()) {
            this.eventBus.sendWithTimeout(address.toString(), message.toString(), timeout.toLong(), (org.vertx.java.core.Handler)sendHandler);
        } else if (message.isNumeric()) {
            this.eventBus.sendWithTimeout(address.toString(), Integer.valueOf(message.toInt()), timeout.toLong(), (org.vertx.java.core.Handler)sendHandler);
        } else if (message.isObject()) {
            this.eventBus.sendWithTimeout(address.toString(), (Buffer)message.toJavaObject(env, Buffer.class), timeout.toLong(), (org.vertx.java.core.Handler)sendHandler);
        } else if (message.isArray()) {
            this.eventBus.sendWithTimeout(address.toString(), PhpTypes.arrayToJson(env, message), timeout.toLong(), (org.vertx.java.core.Handler)sendHandler);
        }
        return this;
    }

    public EventBus publish(Env env, Value address, Value message) {
        if (message.isBoolean()) {
            this.eventBus.publish(address.toString(), Boolean.valueOf(message.toBoolean()));
        } else if (message.isString()) {
            this.eventBus.publish(address.toString(), message.toString());
        } else if (message.isNumeric()) {
            this.eventBus.publish(address.toString(), Integer.valueOf(message.toInt()));
        } else if (message.isObject()) {
            this.eventBus.publish(address.toString(), (Buffer)message.toJavaObject(env, Buffer.class));
        } else if (message.isArray()) {
            this.eventBus.publish(address.toString(), PhpTypes.arrayToJson(env, message));
        }
        return this;
    }

    public void close(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\EventBus::close() must be callable.", new Object[0]);
        this.eventBus.close(HandlerFactory.createAsyncVoidHandler(env, handler));
    }

    public EventBus setDefaultReplyTimeout(Env env, Value timeout) {
        this.eventBus.setDefaultReplyTimeout(timeout.toLong());
        return this;
    }

    public LongValue getDefaultReplyTimeout(Env env) {
        return LongValue.create((long)this.eventBus.getDefaultReplyTimeout());
    }

    public String toString() {
        return "php:Vertx\\EventBus";
    }

    private static class AddressPair<L, R> {
        private L address;
        private R handler;
        private UUID id;

        public AddressPair(L address, R handler) {
            this.address = address;
            this.handler = handler;
            this.id = UUID.randomUUID();
        }

        public UUID getIdentifier() {
            return this.id;
        }

        public L getAddress() {
            return this.address;
        }

        public R getHandler() {
            return this.handler;
        }

        public int hashCode() {
            int hashLeft = this.address != null ? this.address.hashCode() : 0;
            int hashRight = this.handler != null ? this.handler.hashCode() : 0;
            return (hashLeft + hashRight) * hashRight + hashLeft;
        }

        public String toString() {
            return String.format("(%s, %s)", this.address, this.handler);
        }
    }

    private static class PairRegistry<A, H> {
        private Map<UUID, AddressPair<A, H>> registry = new HashMap<UUID, AddressPair<A, H>>();

        public UUID register(AddressPair<A, H> pair) {
            this.registry.put(pair.getIdentifier(), pair);
            return pair.getIdentifier();
        }

        public boolean exists(UUID id) {
            return this.registry.containsKey(id);
        }

        public boolean exists(String id) {
            return this.exists(UUID.fromString(id));
        }

        public AddressPair<A, H> get(UUID id) {
            if (!this.registry.containsKey(id)) {
                return null;
            }
            return this.registry.get(id);
        }

        public AddressPair<A, H> get(String id) {
            return this.get(UUID.fromString(id));
        }

        public void unregister(UUID id) {
            if (this.registry.containsKey(id)) {
                this.registry.remove(id);
            }
        }

        public void unregister(AddressPair<A, H> pair) {
            this.unregister(pair.getIdentifier());
        }
    }
}

