/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.eventbus;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.Gettable;
import io.vertx.lang.php.Handler;
import io.vertx.lang.php.ResultModifier;
import io.vertx.lang.php.util.PhpTypes;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.json.JsonObject;

public class Message<T>
implements Gettable {
    private org.vertx.java.core.eventbus.Message<T> message;
    private boolean isCache;
    private Value cache;

    public Message(org.vertx.java.core.eventbus.Message<T> message) {
        this.message = message;
        this.initCache();
    }

    private void initCache() {
        Object body = this.message.body();
        if (body instanceof JsonObject) {
            this.isCache = true;
            Env env = Env.getCurrent();
            this.cache = PhpTypes.arrayFromJson(env, (JsonObject)this.message.body());
        } else if (body instanceof Buffer) {
            this.isCache = true;
            this.cache = Env.getCurrent().wrapJava((Object)new io.vertx.lang.php.buffer.Buffer((Buffer)body));
        }
    }

    @Override
    public Value __getField(Env env, StringValue name) {
        return env.wrapJava((Object)this).callMethod(env, name);
    }

    public Value body(Env env) {
        if (this.isCache) {
            return this.cache;
        }
        return env.wrapJava(this.message.body());
    }

    public void reply(Env env, @Optional Value message, @Optional Value replyHandler) {
        if (PhpTypes.notNull(message)) {
            if (PhpTypes.notNull(replyHandler)) {
                PhpTypes.assertCallable(env, replyHandler, "Handler argument to Vertx\\EventBus\\Message::reply() must be callable.", new Object[0]);
                Handler handler = new Handler(env, PhpTypes.toCallable(replyHandler), new ResultModifier<org.vertx.java.core.eventbus.Message<T>, Message<T>>(){

                    @Override
                    public Message<T> modify(org.vertx.java.core.eventbus.Message<T> message) {
                        return new Message(message);
                    }
                });
                if (message.isBoolean()) {
                    this.message.reply(Boolean.valueOf(message.toBoolean()), handler);
                } else if (message.isString()) {
                    this.message.reply(message.toString(), handler);
                } else if (message.isNumeric()) {
                    this.message.reply(Integer.valueOf(message.toInt()), handler);
                } else if (message.isDouble()) {
                    this.message.reply(Double.valueOf(message.toDouble()), handler);
                } else if (message.isArray()) {
                    this.message.reply(PhpTypes.arrayToJson(env, message), handler);
                }
            } else if (message.isBoolean()) {
                this.message.reply(Boolean.valueOf(message.toBoolean()));
            } else if (message.isString()) {
                this.message.reply(message.toString());
            } else if (message.isNumeric()) {
                this.message.reply(Integer.valueOf(message.toInt()));
            } else if (message.isDouble()) {
                this.message.reply(Double.valueOf(message.toDouble()));
            } else if (message.isArray()) {
                this.message.reply(PhpTypes.arrayToJson(env, message));
            }
        } else if (PhpTypes.notNull(replyHandler)) {
            PhpTypes.assertCallable(env, replyHandler, "Handler argument to Vertx\\EventBus\\Message::reply() must be callable.", new Object[0]);
            this.message.reply(new Handler(env, PhpTypes.toCallable(replyHandler), new ResultModifier<org.vertx.java.core.eventbus.Message<T>, Message<T>>(){

                @Override
                public Message<T> modify(org.vertx.java.core.eventbus.Message<T> message) {
                    return new Message(message);
                }
            }));
        } else {
            this.message.reply();
        }
    }

    public StringValue replyAddress(Env env) {
        return env.createString(this.message.replyAddress());
    }

    public String toString() {
        return "php:Vertx\\EventBus\\Message";
    }
}

