/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.file;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.streams.ReadStream;
import io.vertx.lang.php.streams.WriteStream;
import io.vertx.lang.php.util.HandlerFactory;
import io.vertx.lang.php.util.PhpTypes;
import org.vertx.java.core.buffer.Buffer;

public final class AsyncFile
implements ReadStream<AsyncFile>,
WriteStream<AsyncFile> {
    private org.vertx.java.core.file.AsyncFile file;

    public AsyncFile(org.vertx.java.core.file.AsyncFile file) {
        this.file = file;
    }

    public AsyncFile read(Env env, io.vertx.lang.php.buffer.Buffer buffer, NumberValue offset, NumberValue position, NumberValue length, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\AsyncFile::read() must be callable.", new Object[0]);
        this.file.read(buffer.__toVertxBuffer(), offset.toInt(), (long)position.toInt(), length.toInt(), HandlerFactory.createAsyncBufferHandler(env, handler));
        return this;
    }

    public AsyncFile write(Env env, io.vertx.lang.php.buffer.Buffer buffer, NumberValue position, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\AsyncFile::write() must be callable.", new Object[0]);
        this.file.write(buffer.__toVertxBuffer(), (long)position.toInt(), HandlerFactory.createAsyncVoidHandler(env, handler));
        return this;
    }

    @Override
    public AsyncFile write(Env env, Value data, StringValue enc) {
        if (data.isString()) {
            this.file.write(new Buffer(data.toString()));
        } else if (data.isObject()) {
            this.file.write(((io.vertx.lang.php.buffer.Buffer)data.toJavaObject(env, io.vertx.lang.php.buffer.Buffer.class)).__toVertxBuffer());
        }
        return this;
    }

    @Override
    public AsyncFile dataHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\AsyncFile::dataHandler() must be callable.", new Object[0]);
        this.file.dataHandler(HandlerFactory.createBufferHandler(env, handler));
        return this;
    }

    @Override
    public AsyncFile pause(Env env) {
        this.file.pause();
        return this;
    }

    @Override
    public AsyncFile resume(Env env) {
        this.file.resume();
        return this;
    }

    @Override
    public AsyncFile endHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\AsyncFile::endHandler() must be callable.", new Object[0]);
        this.file.endHandler(HandlerFactory.createVoidHandler(env, handler));
        return this;
    }

    @Override
    public AsyncFile drainHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\AsyncFile::drainHandler() must be callable.", new Object[0]);
        this.file.drainHandler(HandlerFactory.createVoidHandler(env, handler));
        return this;
    }

    @Override
    public AsyncFile writeQueueMaxSize(Env env, NumberValue value) {
        this.file.setWriteQueueMaxSize(value.toJavaInteger().intValue());
        return this;
    }

    @Override
    public BooleanValue writeQueueFull(Env env) {
        return BooleanValue.create((boolean)this.file.writeQueueFull());
    }

    public AsyncFile flush(Env env, @Optional Value handler) {
        if (PhpTypes.notNull(handler)) {
            PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\AsyncFile::flush() must be callable.", new Object[0]);
            this.file.flush(HandlerFactory.createAsyncVoidHandler(env, handler));
        } else {
            this.file.flush();
        }
        return this;
    }

    public void close(Env env, @Optional Value handler) {
        if (PhpTypes.notNull(handler)) {
            PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\AsyncFile::close() must be callable.", new Object[0]);
            this.file.flush(HandlerFactory.createAsyncVoidHandler(env, handler));
        } else {
            this.file.flush();
        }
    }

    public AsyncFile exceptionHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\AsyncFile::exceptionHandler() must be callable.", new Object[0]);
        this.file.exceptionHandler(HandlerFactory.createExceptionHandler(env, handler));
        return this;
    }

    public String toString() {
        return "php:Vertx\\File\\AsyncFile";
    }
}

