/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.file;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.AsyncResultHandler;
import io.vertx.lang.php.AsyncResultWrapper;
import io.vertx.lang.php.file.AsyncFile;
import io.vertx.lang.php.file.FileProps;
import io.vertx.lang.php.file.FileSystemProps;
import io.vertx.lang.php.util.HandlerFactory;
import io.vertx.lang.php.util.PhpTypes;
import org.vertx.java.core.buffer.Buffer;

public final class FileSystem {
    private org.vertx.java.core.file.FileSystem fileSystem;
    public static final int OPEN_READ = 1;
    public static final int OPEN_WRITE = 2;
    public static final int CREATE_NEW = 4;

    public FileSystem(org.vertx.java.core.file.FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public FileSystem chmod(Env env, StringValue path, StringValue perms, @Optional Value dirPerms, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::chmod() must be callable.", new Object[0]);
        if (PhpTypes.notNull(dirPerms)) {
            this.fileSystem.chmod(path.toString(), perms.toString(), dirPerms.toString(), HandlerFactory.createAsyncVoidHandler(env, handler));
        } else {
            this.fileSystem.chmod(path.toString(), perms.toString(), HandlerFactory.createAsyncVoidHandler(env, handler));
        }
        return this;
    }

    public FileSystem chmodSync(Env env, StringValue path, StringValue perms, @Optional Value dirPerms) {
        if (PhpTypes.notNull(dirPerms)) {
            this.fileSystem.chmodSync(path.toString(), perms.toString(), dirPerms.toString());
        } else {
            this.fileSystem.chmodSync(path.toString(), perms.toString());
        }
        return this;
    }

    public FileSystem copy(Env env, StringValue from, StringValue to, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::copy() must be callable.", new Object[0]);
        this.fileSystem.copy(from.toString(), to.toString(), HandlerFactory.createAsyncVoidHandler(env, handler));
        return this;
    }

    public FileSystem copySync(Env env, StringValue from, StringValue to) {
        this.fileSystem.copySync(from.toString(), to.toString());
        return this;
    }

    public FileSystem copyRecursive(Env env, StringValue from, StringValue to, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::copyRecursive() must be callable.", new Object[0]);
        this.fileSystem.copy(from.toString(), to.toString(), true, HandlerFactory.createAsyncVoidHandler(env, handler));
        return this;
    }

    public FileSystem copyRecursiveSync(Env env, StringValue from, StringValue to) {
        this.fileSystem.copySync(from.toString(), to.toString(), true);
        return this;
    }

    public FileSystem createFile(Env env, StringValue path, @Optional StringValue perms, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::createFile() must be callable.", new Object[0]);
        if (PhpTypes.notNull((Value)perms)) {
            this.fileSystem.createFile(path.toString(), perms.toString(), HandlerFactory.createAsyncVoidHandler(env, handler));
        } else {
            this.fileSystem.createFile(path.toString(), HandlerFactory.createAsyncVoidHandler(env, handler));
        }
        return this;
    }

    public FileSystem createFileSync(Env env, StringValue path, @Optional StringValue perms) {
        if (PhpTypes.notNull((Value)perms)) {
            this.fileSystem.createFileSync(path.toString(), perms.toString());
        } else {
            this.fileSystem.createFileSync(path.toString());
        }
        return this;
    }

    public FileSystem delete(Env env, StringValue path, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::delete() must be callable.", new Object[0]);
        this.fileSystem.delete(path.toString(), HandlerFactory.createAsyncVoidHandler(env, handler));
        return this;
    }

    public FileSystem deleteSync(Env env, StringValue path) {
        this.fileSystem.deleteSync(path.toString());
        return this;
    }

    public FileSystem deleteRecursive(Env env, StringValue path, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::deleteRecursive() must be callable.", new Object[0]);
        this.fileSystem.delete(path.toString(), true, HandlerFactory.createAsyncVoidHandler(env, handler));
        return this;
    }

    public FileSystem deleteRecursiveSync(Env env, StringValue path) {
        this.fileSystem.deleteSync(path.toString(), true);
        return this;
    }

    public FileSystem exists(Env env, StringValue path, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::exists() must be callable.", new Object[0]);
        this.fileSystem.exists(path.toString(), new AsyncResultHandler(env, PhpTypes.toCallable(handler)));
        return this;
    }

    public boolean existsSync(Env env, StringValue path) {
        return this.fileSystem.existsSync(path.toString());
    }

    public FileSystem fsProps(Env env, StringValue path, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::fsProps() must be callable.", new Object[0]);
        this.fileSystem.fsProps(path.toString(), new AsyncResultHandler<org.vertx.java.core.file.FileSystemProps>(env, PhpTypes.toCallable(handler), new AsyncResultWrapper<org.vertx.java.core.file.FileSystemProps, FileSystemProps>(){

            @Override
            public FileSystemProps wrap(org.vertx.java.core.file.FileSystemProps props) {
                return new FileSystemProps(props);
            }
        }));
        return this;
    }

    public FileSystemProps fsPropsSync(Env env, StringValue path) {
        return new FileSystemProps(this.fileSystem.fsPropsSync(path.toString()));
    }

    public FileSystem link(Env env, StringValue link, StringValue existing, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::link() must be callable.", new Object[0]);
        this.fileSystem.link(link.toString(), existing.toString(), HandlerFactory.createAsyncVoidHandler(env, handler));
        return this;
    }

    public FileSystem linkSync(Env env, StringValue link, StringValue existing) {
        this.fileSystem.linkSync(link.toString(), existing.toString());
        return this;
    }

    public FileSystem lprops(Env env, StringValue path, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::lprops() must be callable.", new Object[0]);
        this.fileSystem.lprops(path.toString(), new AsyncResultHandler<org.vertx.java.core.file.FileProps>(env, PhpTypes.toCallable(handler), new AsyncResultWrapper<org.vertx.java.core.file.FileProps, FileProps>(){

            @Override
            public FileProps wrap(org.vertx.java.core.file.FileProps props) {
                return new FileProps(props);
            }
        }));
        return this;
    }

    public FileProps lpropsSync(Env env, StringValue path) {
        return new FileProps(this.fileSystem.lpropsSync(path.toString()));
    }

    public FileSystem mkdir(Env env, StringValue path, @Optional StringValue perms, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::mkdir() must be callable.", new Object[0]);
        if (PhpTypes.notNull((Value)perms)) {
            this.fileSystem.mkdir(path.toString(), perms.toString(), true, HandlerFactory.createAsyncVoidHandler(env, handler));
        } else {
            this.fileSystem.mkdir(path.toString(), true, HandlerFactory.createAsyncVoidHandler(env, handler));
        }
        return this;
    }

    public FileSystem mkdirSync(Env env, StringValue path, @Optional StringValue perms) {
        if (PhpTypes.notNull((Value)perms)) {
            this.fileSystem.mkdirSync(path.toString(), perms.toString(), true);
        } else {
            this.fileSystem.mkdirSync(path.toString(), true);
        }
        return this;
    }

    public FileSystem move(Env env, StringValue from, StringValue to, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::move() must be callable.", new Object[0]);
        this.fileSystem.move(from.toString(), to.toString(), HandlerFactory.createAsyncVoidHandler(env, handler));
        return this;
    }

    public FileSystem moveSync(Env env, StringValue from, StringValue to) {
        this.fileSystem.moveSync(from.toString(), to.toString());
        return this;
    }

    public FileSystem open(Env env, StringValue path, @Optional StringValue perms, @Optional BooleanValue read, @Optional BooleanValue write, @Optional BooleanValue createNew, @Optional BooleanValue flush, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::open() must be callable.", new Object[0]);
        if (PhpTypes.notNull((Value)perms) && PhpTypes.notNull((Value)read) && PhpTypes.notNull((Value)write) && PhpTypes.notNull((Value)createNew) && PhpTypes.notNull((Value)flush)) {
            this.fileSystem.open(path.toString(), perms.toString(), read.toBoolean(), write.toBoolean(), createNew.toBoolean(), flush.toBoolean(), new AsyncResultHandler<org.vertx.java.core.file.AsyncFile>(env, PhpTypes.toCallable(handler), new AsyncResultWrapper<org.vertx.java.core.file.AsyncFile, AsyncFile>(){

                @Override
                public AsyncFile wrap(org.vertx.java.core.file.AsyncFile file) {
                    return new AsyncFile(file);
                }
            }));
        } else if (PhpTypes.notNull((Value)perms) && PhpTypes.notNull((Value)read) && PhpTypes.notNull((Value)write) && PhpTypes.notNull((Value)createNew)) {
            this.fileSystem.open(path.toString(), perms.toString(), read.toBoolean(), write.toBoolean(), createNew.toBoolean(), new AsyncResultHandler<org.vertx.java.core.file.AsyncFile>(env, PhpTypes.toCallable(handler), new AsyncResultWrapper<org.vertx.java.core.file.AsyncFile, AsyncFile>(){

                @Override
                public AsyncFile wrap(org.vertx.java.core.file.AsyncFile file) {
                    return new AsyncFile(file);
                }
            }));
        } else if (PhpTypes.notNull((Value)perms) && PhpTypes.notNull((Value)createNew)) {
            this.fileSystem.open(path.toString(), perms.toString(), createNew.toBoolean(), new AsyncResultHandler<org.vertx.java.core.file.AsyncFile>(env, PhpTypes.toCallable(handler), new AsyncResultWrapper<org.vertx.java.core.file.AsyncFile, AsyncFile>(){

                @Override
                public AsyncFile wrap(org.vertx.java.core.file.AsyncFile file) {
                    return new AsyncFile(file);
                }
            }));
        } else if (PhpTypes.notNull((Value)perms)) {
            this.fileSystem.open(path.toString(), perms.toString(), new AsyncResultHandler<org.vertx.java.core.file.AsyncFile>(env, PhpTypes.toCallable(handler), new AsyncResultWrapper<org.vertx.java.core.file.AsyncFile, AsyncFile>(){

                @Override
                public AsyncFile wrap(org.vertx.java.core.file.AsyncFile file) {
                    return new AsyncFile(file);
                }
            }));
        } else {
            this.fileSystem.open(path.toString(), new AsyncResultHandler<org.vertx.java.core.file.AsyncFile>(env, PhpTypes.toCallable(handler), new AsyncResultWrapper<org.vertx.java.core.file.AsyncFile, AsyncFile>(){

                @Override
                public AsyncFile wrap(org.vertx.java.core.file.AsyncFile file) {
                    return new AsyncFile(file);
                }
            }));
        }
        return this;
    }

    public org.vertx.java.core.file.AsyncFile openSync(Env env, StringValue path, @Optional StringValue perms, @Optional BooleanValue read, @Optional BooleanValue write, @Optional BooleanValue createNew, @Optional BooleanValue flush) {
        if (PhpTypes.notNull((Value)perms) && PhpTypes.notNull((Value)read) && PhpTypes.notNull((Value)write) && PhpTypes.notNull((Value)createNew) && PhpTypes.notNull((Value)flush)) {
            return this.fileSystem.openSync(path.toString(), perms.toString(), read.toBoolean(), write.toBoolean(), createNew.toBoolean(), flush.toBoolean());
        }
        if (PhpTypes.notNull((Value)perms) && PhpTypes.notNull((Value)read) && PhpTypes.notNull((Value)write) && PhpTypes.notNull((Value)createNew)) {
            return this.fileSystem.openSync(path.toString(), perms.toString(), read.toBoolean(), write.toBoolean(), createNew.toBoolean());
        }
        if (PhpTypes.notNull((Value)perms) && PhpTypes.notNull((Value)createNew)) {
            return this.fileSystem.openSync(path.toString(), perms.toString(), createNew.toBoolean());
        }
        if (PhpTypes.notNull((Value)perms)) {
            return this.fileSystem.openSync(path.toString(), perms.toString());
        }
        return this.fileSystem.openSync(path.toString());
    }

    public FileSystem props(Env env, StringValue path, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::props() must be callable.", new Object[0]);
        this.fileSystem.props(path.toString(), new AsyncResultHandler<org.vertx.java.core.file.FileProps>(env, PhpTypes.toCallable(handler), new AsyncResultWrapper<org.vertx.java.core.file.FileProps, FileProps>(){

            @Override
            public FileProps wrap(org.vertx.java.core.file.FileProps props) {
                return new FileProps(props);
            }
        }));
        return this;
    }

    public FileProps propsSync(Env env, StringValue path) {
        return new FileProps(this.fileSystem.propsSync(path.toString()));
    }

    public FileSystem readDir(Env env, StringValue path, @Optional StringValue filter, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::readDir() must be callable.", new Object[0]);
        if (PhpTypes.notNull((Value)filter)) {
            this.fileSystem.readDir(path.toString(), filter.toString(), new AsyncResultHandler(env, PhpTypes.toCallable(handler)));
        } else {
            this.fileSystem.readDir(path.toString(), new AsyncResultHandler(env, PhpTypes.toCallable(handler)));
        }
        return this;
    }

    public String[] readDirSync(Env env, StringValue path, @Optional StringValue filter) {
        if (PhpTypes.notNull((Value)filter)) {
            return this.fileSystem.readDirSync(path.toString(), filter.toString());
        }
        return this.fileSystem.readDirSync(path.toString());
    }

    public FileSystem readFile(Env env, StringValue path, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::readFile() must be callable.", new Object[0]);
        this.fileSystem.readFile(path.toString(), new AsyncResultHandler<Buffer>(env, PhpTypes.toCallable(handler), new AsyncResultWrapper<Buffer, io.vertx.lang.php.buffer.Buffer>(){

            @Override
            public io.vertx.lang.php.buffer.Buffer wrap(Buffer buffer) {
                return new io.vertx.lang.php.buffer.Buffer(buffer);
            }
        }));
        return this;
    }

    public io.vertx.lang.php.buffer.Buffer readFileSync(Env env, StringValue path) {
        return new io.vertx.lang.php.buffer.Buffer(this.fileSystem.readFileSync(path.toString()));
    }

    public FileSystem readSymlink(Env env, StringValue link, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::readSymlink() must be callable.", new Object[0]);
        this.fileSystem.readSymlink(link.toString(), new AsyncResultHandler(env, PhpTypes.toCallable(handler)));
        return this;
    }

    public String readSymlinkSync(Env env, StringValue link) {
        return this.fileSystem.readSymlinkSync(link.toString());
    }

    public FileSystem symlink(Env env, StringValue link, StringValue existing, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::symlink() must be callable.", new Object[0]);
        this.fileSystem.symlink(link.toString(), existing.toString(), HandlerFactory.createAsyncVoidHandler(env, handler));
        return this;
    }

    public FileSystem symlinkSync(Env env, StringValue link, StringValue existing) {
        this.fileSystem.symlinkSync(link.toString(), existing.toString());
        return this;
    }

    public FileSystem truncate(Env env, StringValue path, NumberValue len, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::truncate() must be callable.", new Object[0]);
        this.fileSystem.truncate(path.toString(), len.toLong(), HandlerFactory.createAsyncVoidHandler(env, handler));
        return this;
    }

    public FileSystem truncateSync(Env env, StringValue path, NumberValue len) {
        this.fileSystem.truncateSync(path.toString(), len.toLong());
        return this;
    }

    public FileSystem unlink(Env env, StringValue link, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::unlink() must be callable.", new Object[0]);
        this.fileSystem.unlink(link.toString(), HandlerFactory.createAsyncVoidHandler(env, handler));
        return this;
    }

    public FileSystem unlinkSync(Env env, StringValue link) {
        this.fileSystem.unlinkSync(link.toString());
        return this;
    }

    public FileSystem writeFile(Env env, StringValue path, io.vertx.lang.php.buffer.Buffer buffer, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\File\\FileSystem::writeFile() must be callable.", new Object[0]);
        this.fileSystem.writeFile(path.toString(), buffer.__toVertxBuffer(), HandlerFactory.createAsyncVoidHandler(env, handler));
        return this;
    }

    public FileSystem writeFileSync(Env env, StringValue path, io.vertx.lang.php.buffer.Buffer buffer) {
        this.fileSystem.writeFileSync(path.toString(), buffer.__toVertxBuffer());
        return this;
    }

    public String toString() {
        return "php:Vertx\\FileSystem";
    }
}

