/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.http;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.Handler;
import io.vertx.lang.php.ResultModifier;
import io.vertx.lang.php.TCPClient;
import io.vertx.lang.php.http.HttpClientRequest;
import io.vertx.lang.php.http.HttpClientResponse;
import io.vertx.lang.php.http.WebSocket;
import io.vertx.lang.php.util.HandlerFactory;
import io.vertx.lang.php.util.PhpTypes;
import org.vertx.java.core.http.WebSocketBase;

public class HttpClient
extends TCPClient<org.vertx.java.core.http.HttpClient> {
    public HttpClient(org.vertx.java.core.http.HttpClient client) {
        super(client);
    }

    public HttpClient(Env env, org.vertx.java.core.http.HttpClient client) {
        super(client);
    }

    public StringValue host(Env env) {
        return env.createString(((org.vertx.java.core.http.HttpClient)this.client).getHost());
    }

    public HttpClient host(Env env, StringValue host) {
        if (PhpTypes.notNull((Value)host)) {
            ((org.vertx.java.core.http.HttpClient)this.client).setHost(host.toString());
        } else {
            ((org.vertx.java.core.http.HttpClient)this.client).setHost(null);
        }
        return this;
    }

    public int port(Env env) {
        return ((org.vertx.java.core.http.HttpClient)this.client).getPort();
    }

    public HttpClient port(Env env, NumberValue port) {
        PhpTypes.assertNotNull(env, (Value)port, "Port to Vertx\\Http\\HttpClient::port() must be an integer.", new Object[0]);
        ((org.vertx.java.core.http.HttpClient)this.client).setPort(port.toInt());
        return this;
    }

    public int maxPoolSize(Env env) {
        return ((org.vertx.java.core.http.HttpClient)this.client).getMaxPoolSize();
    }

    public HttpClient maxPoolSize(Env env, NumberValue size) {
        PhpTypes.assertNotNull(env, (Value)size, "Size to Vertx\\Http\\HttpClient::maxPoolSize() must be an integer.", new Object[0]);
        ((org.vertx.java.core.http.HttpClient)this.client).setMaxPoolSize(size.toInt());
        return this;
    }

    public int connectTimeout(Env env) {
        return ((org.vertx.java.core.http.HttpClient)this.client).getConnectTimeout();
    }

    public HttpClient connectTimeout(Env env, NumberValue timeout) {
        PhpTypes.assertNotNull(env, (Value)timeout, "Timeout to Vertx\\Http\\HttpClient::connectTimeout() must be an integer.", new Object[0]);
        ((org.vertx.java.core.http.HttpClient)this.client).setConnectTimeout(timeout.toInt());
        return this;
    }

    public boolean verifyHost(Env env) {
        return ((org.vertx.java.core.http.HttpClient)this.client).isVerifyHost();
    }

    public HttpClient verifyHost(Env env, BooleanValue verifyHost) {
        PhpTypes.assertNotNull(env, (Value)verifyHost, "Value to Vertx\\Http\\HttpClient::verifyHost() must be a boolean.", new Object[0]);
        ((org.vertx.java.core.http.HttpClient)this.client).setVerifyHost(verifyHost.toBoolean());
        return this;
    }

    public HttpClientRequest connect(Env env, StringValue uri, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\HttpClient::connect() must be callable.", new Object[0]);
        return new HttpClientRequest(((org.vertx.java.core.http.HttpClient)this.client).connect(uri.toString(), this.createResponseHandler(env, handler)));
    }

    public HttpClient connectWebsocket(Env env, StringValue uri, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\HttpClient::connectWebsocket() must be callable.", new Object[0]);
        ((org.vertx.java.core.http.HttpClient)this.client).connectWebsocket(uri.toString(), new Handler<org.vertx.java.core.http.WebSocket>(env, PhpTypes.toCallable(handler), new ResultModifier<org.vertx.java.core.http.WebSocket, WebSocket>(){

            @Override
            public WebSocket modify(org.vertx.java.core.http.WebSocket socket) {
                return new WebSocket((WebSocketBase<?>)socket);
            }
        }));
        return this;
    }

    public HttpClientRequest request(Env env, StringValue method, StringValue uri, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\HttpClient::request() must be callable.", new Object[0]);
        return new HttpClientRequest(((org.vertx.java.core.http.HttpClient)this.client).request(method.toString(), uri.toString(), this.createResponseHandler(env, handler)));
    }

    public HttpClientRequest get(Env env, StringValue uri, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\HttpClient::get() must be callable.", new Object[0]);
        return new HttpClientRequest(((org.vertx.java.core.http.HttpClient)this.client).get(uri.toString(), this.createResponseHandler(env, handler)));
    }

    public HttpClient getNow(Env env, StringValue uri, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\HttpClient::getNow() must be callable.", new Object[0]);
        ((org.vertx.java.core.http.HttpClient)this.client).getNow(uri.toString(), this.createResponseHandler(env, handler));
        return this;
    }

    public HttpClientRequest put(Env env, StringValue uri, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\HttpClient::put() must be callable.", new Object[0]);
        return new HttpClientRequest(((org.vertx.java.core.http.HttpClient)this.client).put(uri.toString(), this.createResponseHandler(env, handler)));
    }

    public HttpClientRequest post(Env env, StringValue uri, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\HttpClient::post() must be callable.", new Object[0]);
        return new HttpClientRequest(((org.vertx.java.core.http.HttpClient)this.client).post(uri.toString(), this.createResponseHandler(env, handler)));
    }

    public HttpClientRequest delete(Env env, StringValue uri, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\HttpClient::delete() must be callable.", new Object[0]);
        return new HttpClientRequest(((org.vertx.java.core.http.HttpClient)this.client).delete(uri.toString(), this.createResponseHandler(env, handler)));
    }

    public HttpClientRequest head(Env env, StringValue uri, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\HttpClient::head() must be callable.", new Object[0]);
        return new HttpClientRequest(((org.vertx.java.core.http.HttpClient)this.client).head(uri.toString(), this.createResponseHandler(env, handler)));
    }

    public HttpClientRequest patch(Env env, StringValue uri, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\HttpClient::patch() must be callable.", new Object[0]);
        return new HttpClientRequest(((org.vertx.java.core.http.HttpClient)this.client).patch(uri.toString(), this.createResponseHandler(env, handler)));
    }

    public HttpClientRequest trace(Env env, StringValue uri, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\HttpClient::trace() must be callable.", new Object[0]);
        return new HttpClientRequest(((org.vertx.java.core.http.HttpClient)this.client).trace(uri.toString(), this.createResponseHandler(env, handler)));
    }

    public HttpClientRequest options(Env env, StringValue uri, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\HttpClient::options() must be callable.", new Object[0]);
        return new HttpClientRequest(((org.vertx.java.core.http.HttpClient)this.client).options(uri.toString(), this.createResponseHandler(env, handler)));
    }

    private Handler<org.vertx.java.core.http.HttpClientResponse> createResponseHandler(Env env, Value handler) {
        return new Handler<org.vertx.java.core.http.HttpClientResponse>(env, PhpTypes.toCallable(handler), new ResultModifier<org.vertx.java.core.http.HttpClientResponse, HttpClientResponse>(){

            @Override
            public HttpClientResponse modify(org.vertx.java.core.http.HttpClientResponse response) {
                return new HttpClientResponse(response);
            }
        });
    }

    public HttpClient exceptionHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\HttpClient::exceptionHandler() must be callable.", new Object[0]);
        ((org.vertx.java.core.http.HttpClient)this.client).exceptionHandler(HandlerFactory.createExceptionHandler(env, handler));
        return this;
    }

    public void close(Env env) {
        ((org.vertx.java.core.http.HttpClient)this.client).close();
    }

    @Override
    public String toString() {
        return "php:Vertx\\Http\\HttpClient";
    }
}

