/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.http;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.Gettable;
import io.vertx.lang.php.MultiMapArray;
import io.vertx.lang.php.Settable;
import io.vertx.lang.php.buffer.Buffer;
import io.vertx.lang.php.streams.ExceptionSupport;
import io.vertx.lang.php.streams.WriteStream;
import io.vertx.lang.php.util.HandlerFactory;
import io.vertx.lang.php.util.PhpTypes;

public class HttpClientRequest
implements WriteStream<HttpClientRequest>,
ExceptionSupport<HttpClientRequest>,
Gettable,
Settable {
    private org.vertx.java.core.http.HttpClientRequest request;

    public HttpClientRequest(org.vertx.java.core.http.HttpClientRequest request) {
        this.request = request;
    }

    public HttpClientRequest(Env env, org.vertx.java.core.http.HttpClientRequest request) {
        this.request = request;
    }

    @Override
    public Value __getField(Env env, StringValue name) {
        return env.wrapJava((Object)this).callMethod(env, name);
    }

    @Override
    public void __setField(Env env, StringValue name, Value value) {
        env.wrapJava((Object)this).callMethod(env, name, value);
    }

    public Value headers(Env env) {
        return env.wrapJava((Object)new MultiMapArray(this.request.headers()));
    }

    public Value putHeader(Env env, StringValue name, Value value) {
        this.request.putHeader(name.toString(), value.toString());
        return env.wrapJava((Object)this);
    }

    public Value sendHead(Env env) {
        this.request.sendHead();
        return env.wrapJava((Object)this);
    }

    @Override
    public HttpClientRequest write(Env env, Value data, @Optional StringValue enc) {
        if (enc != null && !enc.isDefault()) {
            if (data.isObject()) {
                this.request.write(((Buffer)data.toJavaObject(env, Buffer.class)).__toVertxBuffer());
            } else {
                this.request.write(data.toString(), enc.toString());
            }
        } else if (data.isObject()) {
            this.request.write(((Buffer)data.toJavaObject(env, Buffer.class)).__toVertxBuffer());
        } else {
            this.request.write(data.toString());
        }
        return this;
    }

    public HttpClientRequest continueHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Http\\HttpClientRequest::continueHandler() must be callable.", new Object[0]);
        this.request.continueHandler(HandlerFactory.createVoidHandler(env, handler));
        return this;
    }

    public void end() {
        this.request.end();
    }

    public void end(Env env) {
        this.end();
    }

    public void end(Env env, Value data) {
        this.request.end(data.toString());
    }

    @Override
    public HttpClientRequest drainHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Http\\HttpClientRequest::drainHandler() must be callable.", new Object[0]);
        this.request.drainHandler(HandlerFactory.createVoidHandler(env, handler));
        return this;
    }

    public HttpClientRequest timeout(Env env, Value timeoutMs) {
        this.request.setTimeout((long)timeoutMs.toInt());
        return this;
    }

    public HttpClientRequest chunked(Env env, BooleanValue chunked) {
        this.request.setChunked(chunked.toBoolean());
        return this;
    }

    public BooleanValue chunked(Env env) {
        return BooleanValue.create((boolean)this.request.isChunked());
    }

    @Override
    public HttpClientRequest writeQueueMaxSize(Env env, NumberValue size) {
        this.request.setWriteQueueMaxSize(size.toInt());
        return this;
    }

    @Override
    public BooleanValue writeQueueFull(Env env) {
        return BooleanValue.create((boolean)this.request.writeQueueFull());
    }

    @Override
    public HttpClientRequest exceptionHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Http\\HttpClientRequest::exceptionhandler() must be callable.", new Object[0]);
        this.request.exceptionHandler(HandlerFactory.createExceptionHandler(env, handler));
        return this;
    }

    public String toString() {
        return "php:Vertx\\Http\\HttpClientRequest";
    }
}

