/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.http;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.Gettable;
import io.vertx.lang.php.Handler;
import io.vertx.lang.php.MultiMapArray;
import io.vertx.lang.php.ResultModifier;
import io.vertx.lang.php.http.HttpServerFileUpload;
import io.vertx.lang.php.http.HttpServerResponse;
import io.vertx.lang.php.net.NetSocket;
import io.vertx.lang.php.streams.ReadStream;
import io.vertx.lang.php.util.HandlerFactory;
import io.vertx.lang.php.util.PhpTypes;
import javax.net.ssl.SSLPeerUnverifiedException;

public class HttpServerRequest
implements ReadStream<HttpServerRequest>,
Gettable {
    private org.vertx.java.core.http.HttpServerRequest request;

    public HttpServerRequest(org.vertx.java.core.http.HttpServerRequest request) {
        this.request = request;
    }

    public HttpServerRequest(Env env, org.vertx.java.core.http.HttpServerRequest request) {
        this.request = request;
    }

    @Override
    public Value __getField(Env env, StringValue name) {
        return env.wrapJava((Object)this).callMethod(env, name);
    }

    public Value headers(Env env) {
        return env.wrapJava((Object)new MultiMapArray(this.request.headers()));
    }

    public Value method(Env env) {
        return env.wrapJava((Object)this.request.method());
    }

    public Value params(Env env) {
        return env.wrapJava((Object)new MultiMapArray(this.request.params()));
    }

    public Value path(Env env) {
        return env.wrapJava((Object)this.request.path());
    }

    public Value query(Env env) {
        return env.wrapJava((Object)this.request.query());
    }

    public Value uri(Env env) {
        return env.wrapJava((Object)this.request.uri());
    }

    public Value absoluteURI(Env env) {
        return env.wrapJava((Object)this.request.absoluteURI());
    }

    public Value response(Env env) {
        return env.wrapJava((Object)new HttpServerResponse(this.request.response()));
    }

    public Value version(Env env) {
        return env.wrapJava((Object)this.request.version());
    }

    public Value remoteAddress(Env env) {
        return env.wrapJava((Object)this.request.remoteAddress());
    }

    public Value netSocket(Env env) {
        return env.wrapJava((Object)new NetSocket(this.request.netSocket()));
    }

    public Value formAttributes(Env env) {
        return env.wrapJava((Object)new MultiMapArray(this.request.formAttributes()));
    }

    public Value peerCertificateChain(Env env) {
        try {
            return env.wrapJava((Object)this.request.peerCertificateChain());
        }
        catch (SSLPeerUnverifiedException e) {
            return null;
        }
    }

    public Value expectMultiPart(Env env, BooleanValue expect) {
        this.request.expectMultiPart(expect.toBoolean());
        return env.wrapJava((Object)this);
    }

    @Override
    public HttpServerRequest pause(Env env) {
        this.request.pause();
        return this;
    }

    @Override
    public HttpServerRequest resume(Env env) {
        this.request.resume();
        return this;
    }

    public HttpServerRequest bodyHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Http\\HttpServerRequest::bodyHandler() must be callable.", new Object[0]);
        this.request.bodyHandler(HandlerFactory.createBufferHandler(env, handler));
        return this;
    }

    public HttpServerRequest uploadHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Http\\HttpServerRequest::uploadHandler() must be callable.", new Object[0]);
        this.request.uploadHandler(new Handler<org.vertx.java.core.http.HttpServerFileUpload>(env, PhpTypes.toCallable(handler), new ResultModifier<org.vertx.java.core.http.HttpServerFileUpload, HttpServerFileUpload>(){

            @Override
            public HttpServerFileUpload modify(org.vertx.java.core.http.HttpServerFileUpload upload) {
                return new HttpServerFileUpload(upload);
            }
        }));
        return this;
    }

    @Override
    public HttpServerRequest dataHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Http\\HttpServerRequest::dataHandler() must be callable.", new Object[0]);
        this.request.dataHandler(HandlerFactory.createBufferHandler(env, handler));
        return this;
    }

    @Override
    public HttpServerRequest endHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Http\\HttpServerRequest::endHandler() must be callable.", new Object[0]);
        this.request.endHandler(HandlerFactory.createVoidHandler(env, handler));
        return this;
    }

    public String toString() {
        return "php:Vertx\\Http\\HttpServerRequest";
    }
}

