/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.http;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.Gettable;
import io.vertx.lang.php.MultiMapArray;
import io.vertx.lang.php.Settable;
import io.vertx.lang.php.buffer.Buffer;
import io.vertx.lang.php.streams.ExceptionSupport;
import io.vertx.lang.php.streams.WriteStream;
import io.vertx.lang.php.util.HandlerFactory;
import io.vertx.lang.php.util.PhpTypes;

public class HttpServerResponse
implements WriteStream<HttpServerResponse>,
ExceptionSupport<HttpServerResponse>,
Gettable,
Settable {
    private org.vertx.java.core.http.HttpServerResponse response;

    public HttpServerResponse(org.vertx.java.core.http.HttpServerResponse response) {
        this.response = response;
    }

    public HttpServerResponse(Env env, org.vertx.java.core.http.HttpServerResponse response) {
        this.response = response;
    }

    @Override
    public Value __getField(Env env, StringValue name) {
        return env.wrapJava((Object)this).callMethod(env, name);
    }

    @Override
    public void __setField(Env env, StringValue name, Value value) {
        env.wrapJava((Object)this).callMethod(env, name, value);
    }

    public Value statusCode(Env env) {
        return env.wrapJava((Object)this.response.getStatusCode());
    }

    public Value statusCode(Env env, NumberValue statusCode) {
        this.response.setStatusCode(statusCode.toInt());
        return env.wrapJava((Object)this);
    }

    public Value statusMessage(Env env) {
        return env.createString(this.response.getStatusMessage());
    }

    public HttpServerResponse statusMessage(Env env, StringValue message) {
        this.response.setStatusMessage(message.toString());
        return this;
    }

    public Value headers(Env env) {
        return env.wrapJava((Object)new MultiMapArray(this.response.headers()));
    }

    public HttpServerResponse putHeader(Env env, StringValue name, Value value) {
        this.response.putHeader(name.toString(), value.toString());
        return this;
    }

    public Value trailers(Env env) {
        return env.wrapJava((Object)new MultiMapArray(this.response.trailers()));
    }

    public HttpServerResponse putTrailer(Env env, StringValue name, Value value) {
        this.response.putTrailer(name.toString(), value.toString());
        return this;
    }

    public HttpServerResponse sendFile(Env env, StringValue filename) {
        this.response.sendFile(filename.toString());
        return this;
    }

    @Override
    public HttpServerResponse write(Env env, Value data, @Optional StringValue enc) {
        if (PhpTypes.notNull((Value)enc) && !enc.isDefault()) {
            if (data.isObject()) {
                this.response.write(((Buffer)data.toJavaObject(env, Buffer.class)).__toVertxBuffer());
            } else {
                this.response.write(data.toString(), enc.toString());
            }
        } else if (data.isObject()) {
            this.response.write(((Buffer)data.toJavaObject(env, Buffer.class)).__toVertxBuffer());
        } else {
            this.response.write(data.toString());
        }
        return this;
    }

    public void end() {
        this.response.end();
    }

    public void end(Env env) {
        this.end();
    }

    public void end(Env env, Value data) {
        this.response.end(data.toString());
    }

    @Override
    public HttpServerResponse drainHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Http\\HttpServerResponse::drainHandler() must be callable.", new Object[0]);
        this.response.drainHandler(HandlerFactory.createVoidHandler(env, handler));
        return this;
    }

    public HttpServerResponse closeHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Http\\HttpServerResponse::closeHandler() must be callable.", new Object[0]);
        this.response.closeHandler(HandlerFactory.createVoidHandler(env, handler));
        return this;
    }

    public BooleanValue chunked(Env env) {
        return BooleanValue.create((boolean)this.response.isChunked());
    }

    public HttpServerResponse chunked(Env env, BooleanValue chunked) {
        PhpTypes.assertNotNull(env, (Value)chunked, "Value to Vertx\\Http\\HttpServerResponse::chunked() must be a boolean.", new Object[0]);
        this.response.setChunked(chunked.toBoolean());
        return this;
    }

    @Override
    public HttpServerResponse writeQueueMaxSize(Env env, NumberValue size) {
        PhpTypes.assertNotNull(env, (Value)size, "Size to Vertx\\Http\\HttpServerResponse::writeQueueMaxSize() must be an integer.", new Object[0]);
        this.response.setWriteQueueMaxSize(size.toInt());
        return this;
    }

    @Override
    public BooleanValue writeQueueFull(Env env) {
        return BooleanValue.create((boolean)this.response.writeQueueFull());
    }

    @Override
    public HttpServerResponse exceptionHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Http\\HttpServerResponse::exceptionHandler() must be callable.", new Object[0]);
        this.response.exceptionHandler(HandlerFactory.createExceptionHandler(env, handler));
        return this;
    }

    public String toString() {
        return "php:Vertx\\Http\\HttpServerResponse";
    }
}

