/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.http;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.Gettable;
import io.vertx.lang.php.streams.ExceptionSupport;
import io.vertx.lang.php.streams.ReadStream;
import io.vertx.lang.php.streams.WriteStream;
import io.vertx.lang.php.util.HandlerFactory;
import io.vertx.lang.php.util.PhpTypes;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.WebSocketBase;
import org.vertx.java.core.http.WebSocketVersion;

public class WebSocket
implements ReadStream<WebSocket>,
WriteStream<WebSocket>,
ExceptionSupport<WebSocket>,
Gettable {
    private org.vertx.java.core.http.WebSocket socket;
    public static final WebSocketVersion HYBI_00 = WebSocketVersion.HYBI_00;
    public static final WebSocketVersion HYBI_08 = WebSocketVersion.HYBI_08;
    public static final WebSocketVersion RFC6455 = WebSocketVersion.RFC6455;

    public WebSocket(WebSocketBase<?> socket) {
        this.socket = (org.vertx.java.core.http.WebSocket)socket;
    }

    public WebSocket(Env env, WebSocketBase<?> socket) {
        this.socket = (org.vertx.java.core.http.WebSocket)socket;
    }

    @Override
    public Value __getField(Env env, StringValue name) {
        return env.wrapJava((Object)this).callMethod(env, name);
    }

    @Override
    public WebSocket write(Env env, Value data, StringValue enc) {
        this.socket.write(new Buffer(data.toString()));
        return this;
    }

    public WebSocket writeBinaryFrame(Env env, Value data) {
        this.socket.writeBinaryFrame(new Buffer(data.toString()));
        return this;
    }

    public StringValue binaryHandlerID(Env env) {
        return env.createString(this.socket.binaryHandlerID());
    }

    public WebSocket writeTextFrame(Env env, Value data) {
        this.socket.writeTextFrame(data.toString());
        return this;
    }

    public StringValue textHandlerID(Env env) {
        return env.createString(this.socket.textHandlerID());
    }

    @Override
    public WebSocket drainHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\WebSocket::drainHandler() must be callable.", new Object[0]);
        this.socket.drainHandler(HandlerFactory.createVoidHandler(env, handler));
        return this;
    }

    @Override
    public WebSocket writeQueueMaxSize(Env env, NumberValue size) {
        this.socket.setWriteQueueMaxSize(size.toInt());
        return this;
    }

    @Override
    public BooleanValue writeQueueFull(Env env) {
        return BooleanValue.create((boolean)this.socket.writeQueueFull());
    }

    @Override
    public WebSocket pause(Env env) {
        this.socket.pause();
        return this;
    }

    @Override
    public WebSocket resume(Env env) {
        this.socket.resume();
        return this;
    }

    @Override
    public WebSocket dataHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\WebSocket::dataHandler() must be callable.", new Object[0]);
        this.socket.dataHandler(HandlerFactory.createBufferHandler(env, handler));
        return this;
    }

    @Override
    public WebSocket endHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\WebSocket::endHandler() must be callable.", new Object[0]);
        this.socket.endHandler(HandlerFactory.createVoidHandler(env, handler));
        return this;
    }

    @Override
    public WebSocket exceptionHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\WebSocket::exceptionHandler() must be callable.", new Object[0]);
        this.socket.exceptionHandler(HandlerFactory.createExceptionHandler(env, handler));
        return this;
    }

    public Value closeHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Argument to Vertx\\Http\\WebSocket::closeHandler() must be callable.", new Object[0]);
        this.socket.closeHandler(HandlerFactory.createVoidHandler(env, handler));
        return env.wrapJava((Object)this);
    }

    public void close() {
        this.socket.close();
    }

    public String toString() {
        return "php:Vertx\\Http\\WebSocket";
    }
}

