/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.net;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.Gettable;
import io.vertx.lang.php.buffer.Buffer;
import io.vertx.lang.php.streams.ExceptionSupport;
import io.vertx.lang.php.streams.ReadStream;
import io.vertx.lang.php.streams.WriteStream;
import io.vertx.lang.php.util.HandlerFactory;
import io.vertx.lang.php.util.PhpTypes;

public class NetSocket
implements ReadStream<NetSocket>,
WriteStream<NetSocket>,
ExceptionSupport<NetSocket>,
Gettable {
    private org.vertx.java.core.net.NetSocket socket;

    public NetSocket(org.vertx.java.core.net.NetSocket socket) {
        this.socket = socket;
    }

    @Override
    public Value __getField(Env env, StringValue name) {
        return env.wrapJava((Object)this).callMethod(env, name);
    }

    public Value localAddress(Env env) {
        return env.createString(this.socket.localAddress().toString());
    }

    public Value remoteAddress(Env env) {
        return env.createString(this.socket.remoteAddress().toString());
    }

    @Override
    public NetSocket dataHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Net\\NetSocket::dataHandler() must be callable.", new Object[0]);
        this.socket.dataHandler(HandlerFactory.createBufferHandler(env, handler));
        return this;
    }

    @Override
    public NetSocket pause(Env env) {
        this.socket.pause();
        return this;
    }

    @Override
    public NetSocket resume(Env env) {
        this.socket.resume();
        return this;
    }

    @Override
    public NetSocket endHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Net\\NetSocket::endHandler() must be callable.", new Object[0]);
        this.socket.endHandler(HandlerFactory.createVoidHandler(env, handler));
        return this;
    }

    @Override
    public NetSocket drainHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Net\\NetSocket::drainHandler() must be callable.", new Object[0]);
        this.socket.drainHandler(HandlerFactory.createVoidHandler(env, handler));
        return this;
    }

    @Override
    public NetSocket writeQueueMaxSize(Env env, NumberValue value) {
        this.socket.setWriteQueueMaxSize(value.toInt());
        return this;
    }

    @Override
    public BooleanValue writeQueueFull(Env env) {
        return BooleanValue.create((boolean)this.socket.writeQueueFull());
    }

    @Override
    public NetSocket write(Env env, Value data, StringValue enc) {
        if (data.isObject()) {
            this.socket.write(((Buffer)data.toJavaObject(env, Buffer.class)).__toVertxBuffer());
        } else {
            this.socket.write(data.toString());
        }
        return this;
    }

    public NetSocket sendFile(Env env, StringValue filename) {
        return this;
    }

    public void closeHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Net\\NetSocket::closeHandler() must be callable.", new Object[0]);
        this.socket.closeHandler(HandlerFactory.createVoidHandler(env, handler));
    }

    public void close(Env env) {
        this.socket.close();
    }

    @Override
    public NetSocket exceptionHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler, "Handler argument to Vertx\\Net\\NetSocket::exceptionHandler() must be callable.", new Object[0]);
        this.socket.exceptionHandler(HandlerFactory.createExceptionHandler(env, handler));
        return this;
    }

    public String toString() {
        return "php:Vertx\\Net\\NetSocket";
    }
}

