/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.streams;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.streams.ReadStream;
import io.vertx.lang.php.streams.WriteStream;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;

public class Pump {
    private Env env;
    private ReadStream<?> readStream;
    private WriteStream<?> writeStream;
    private int pumped;
    private final Handler<Void> drainHandler = new Handler<Void>(){

        public void handle(Void v) {
            Pump.this.readStream.resume(Pump.this.env);
        }
    };
    private final Value drainHandlerValue = new Callback(){
        private static final long serialVersionUID = 1L;

        public Value call(Env arg0, Value arg1) {
            Pump.this.drainHandler.handle(null);
            return Pump.this.env.wrapJava((Object)this);
        }

        public Value call(Env env, Value[] args) {
            Pump.this.drainHandler.handle(null);
            return env.wrapJava((Object)this);
        }

        public String getCallbackName() {
            return Pump.this.drainHandler.toString();
        }

        public boolean isInternal(Env arg0) {
            return false;
        }

        public boolean isValid(Env arg0) {
            return true;
        }

        public boolean isCallable(Env env, boolean a, Value b) {
            return true;
        }
    };
    private final Handler<Buffer> dataHandler = new Handler<Buffer>(){

        public void handle(Buffer buffer) {
            Pump.this.writeStream.write(Pump.this.env, Pump.this.env.wrapJava((Object)buffer.toString()), null);
            Pump.this.pumped += buffer.length();
            if (Pump.this.writeStream.writeQueueFull(Pump.this.env).toBoolean()) {
                Pump.this.readStream.pause(Pump.this.env);
                Pump.this.writeStream.drainHandler(Pump.this.env, Pump.this.drainHandlerValue);
            }
        }
    };
    private final Value dataHandlerValue = new Callback(){
        private static final long serialVersionUID = 1L;

        public Value call(Env arg0, Value arg1) {
            Pump.this.dataHandler.handle((Object)new Buffer(arg1.toString()));
            return Pump.this.env.wrapJava((Object)this);
        }

        public Value call(Env env, Value[] args) {
            Pump.this.dataHandler.handle((Object)new Buffer(args[0].toString()));
            return env.wrapJava((Object)this);
        }

        public String getCallbackName() {
            return Pump.this.dataHandler.toString();
        }

        public boolean isInternal(Env arg0) {
            return false;
        }

        public boolean isValid(Env arg0) {
            return true;
        }

        public boolean isCallable(Env env, boolean a, Value b) {
            return true;
        }
    };

    public Pump(Env env, ReadStream<?> readStream, WriteStream<?> writeStream, @Optional NumberValue writeQueueMaxSize) {
        this.env = env;
        this.readStream = readStream;
        this.writeStream = writeStream;
        if (writeQueueMaxSize != null) {
            this.writeStream.writeQueueMaxSize(env, writeQueueMaxSize);
        }
    }

    public static Pump createPump(Env env, ReadStream<?> readStream, WriteStream<?> writeStream, @Optional NumberValue writeQueueMaxSize) {
        return new Pump(env, readStream, writeStream, writeQueueMaxSize);
    }

    public Pump setWriteQueueMaxSize(Env env, NumberValue maxSize) {
        this.writeStream.writeQueueMaxSize(env, maxSize);
        return this;
    }

    public Pump start(Env env) {
        this.readStream.dataHandler(env, this.dataHandlerValue);
        return this;
    }

    public Pump stop(Env env) {
        this.writeStream.drainHandler(env, null);
        this.readStream.dataHandler(env, null);
        return this;
    }

    public int bytesPumped(Env env) {
        return this.pumped;
    }
}

