/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.testtools;

import com.caucho.quercus.annotation.ClassImplementation;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.This;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.testtools.PhpTestRunner;
import io.vertx.lang.php.util.PhpTypes;
import java.util.HashMap;
import org.junit.Assert;
import org.vertx.testtools.VertxAssert;

@ClassImplementation
public abstract class PhpTestCase {
    public static Value __construct(Env env, @This ObjectValue obj) {
        return obj;
    }

    public static void setUp(Env env, @This ObjectValue obj) {
    }

    public static void assertTrue(Env env, @This ObjectValue obj, BooleanValue condition, @Optional StringValue message) {
        PhpTestCase.doAssertTrue(condition.toBoolean(), message);
    }

    private static void doAssertTrue(boolean condition, StringValue message) {
        if (PhpTypes.notNull((Value)message)) {
            VertxAssert.assertTrue((String)message.toString(), (boolean)condition);
        } else {
            VertxAssert.assertTrue((boolean)condition);
        }
    }

    public static void assertFalse(Env env, @This ObjectValue obj, BooleanValue condition, @Optional StringValue message) {
        PhpTestCase.doAssertFalse(condition.toBoolean(), message);
    }

    private static void doAssertFalse(boolean condition, StringValue message) {
        if (PhpTypes.notNull((Value)message)) {
            VertxAssert.assertFalse((String)message.toString(), (boolean)condition);
        } else {
            VertxAssert.assertFalse((boolean)condition);
        }
    }

    public static void assertNull(Env env, @This ObjectValue obj, Value value) {
        VertxAssert.assertTrue((boolean)PhpTypes.isNull(value));
    }

    public static void assertNotNull(Env env, @This ObjectValue obj, Value value) {
        VertxAssert.assertTrue((boolean)PhpTypes.notNull(value));
    }

    public static void assertEquals(Env env, @This ObjectValue obj, Value expected, Value actual, @Optional StringValue message) {
        if (expected.isBoolean()) {
            if (!actual.isBoolean()) {
                PhpTestCase.doAssertTrue(false, message);
            } else if (expected.toBoolean()) {
                PhpTestCase.doAssertTrue(actual.toBoolean(), message);
            } else {
                PhpTestCase.doAssertFalse(actual.toBoolean(), message);
            }
        } else if (expected.isDouble()) {
            PhpTestCase.doAssertEquals(expected.toDouble(), actual.toDouble(), message);
        } else if (expected.isLong()) {
            PhpTestCase.doAssertEquals(expected.toLong(), actual.toLong(), message);
        } else if (expected.isNull()) {
            PhpTestCase.doAssertTrue(actual.isNull(), message);
        } else if (expected.isString()) {
            if (!actual.isString()) {
                PhpTestCase.doAssertTrue(false, message);
            } else {
                PhpTestCase.doAssertEquals(expected.toString(), actual.toString(), message);
            }
        } else if (expected.isObject()) {
            if (!actual.isObject()) {
                PhpTestCase.doAssertTrue(false, message);
            } else {
                PhpTestCase.doAssertEquals(expected.toJavaObject(), actual.toJavaObject(), message);
            }
        } else if (expected.isArray()) {
            if (!actual.isArray()) {
                PhpTestCase.doAssertTrue(false, message);
            } else {
                PhpTestCase.doAssertEquals(expected.toJavaMap(env, new HashMap().getClass()), actual.toJavaMap(env, new HashMap().getClass()), message);
            }
        } else {
            PhpTestCase.doAssertTrue(actual.eq(expected), message);
        }
    }

    private static <T> void doAssertEquals(T expected, T actual, StringValue message) {
        if (PhpTypes.notNull((Value)message)) {
            VertxAssert.assertEquals((String)message.toString(), expected, actual);
        } else {
            VertxAssert.assertEquals(expected, actual);
        }
    }

    public static void assertNotEquals(Env env, @This ObjectValue obj, Value expected, Value actual, @Optional StringValue message) {
        if (expected.isBoolean()) {
            if (actual.isBoolean()) {
                if (expected.toBoolean()) {
                    PhpTestCase.doAssertFalse(actual.toBoolean(), message);
                } else {
                    PhpTestCase.doAssertTrue(actual.toBoolean(), message);
                }
            }
        } else if (expected.isDouble()) {
            PhpTestCase.doAssertNotEquals(expected.toDouble(), actual.toDouble(), message);
        } else if (expected.isLong()) {
            PhpTestCase.doAssertNotEquals(expected.toLong(), actual.toLong(), message);
        } else if (expected.isNull()) {
            PhpTestCase.doAssertFalse(actual.isNull(), message);
        } else if (expected.isString()) {
            if (actual.isString()) {
                PhpTestCase.doAssertNotEquals(expected.toString(), actual.toString(), message);
            }
        } else if (expected.isObject()) {
            if (actual.isObject()) {
                PhpTestCase.doAssertNotEquals(expected.toJavaObject(), actual.toJavaObject(), message);
            }
        } else {
            PhpTestCase.doAssertFalse(actual.eq(expected), message);
        }
    }

    private static <T> void doAssertNotEquals(T expected, T actual, StringValue message) {
        try {
            Assert.assertEquals(expected, actual);
            PhpTestCase.doAssertTrue(false, message);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    public static void assertSame(Env env, @This ObjectValue obj, Value expected, Value actual, @Optional StringValue message) {
        if (PhpTypes.notNull((Value)message)) {
            VertxAssert.assertSame((String)message.toString(), (Object)expected.toValue(), (Object)actual.toValue());
        } else {
            VertxAssert.assertSame((Object)expected.toValue(), (Object)actual.toValue());
        }
    }

    public static void assertNotSame(Env env, @This ObjectValue obj, Value expected, Value actual, @Optional StringValue message) {
        if (PhpTypes.notNull((Value)message)) {
            VertxAssert.assertNotSame((String)message.toString(), (Object)expected.toValue(), (Object)actual.toValue());
        } else {
            VertxAssert.assertNotSame((Object)expected.toValue(), (Object)actual.toValue());
        }
    }

    public static void fail(Env env, @This ObjectValue obj, @Optional StringValue message) {
        if (PhpTypes.notNull((Value)message)) {
            VertxAssert.fail((String)message.toString());
        } else {
            VertxAssert.fail();
        }
    }

    public static void complete(Env env, @This ObjectValue obj) {
        PhpTestRunner.cleanUp(env);
        VertxAssert.testComplete();
    }

    public static void tearDown(Env env, @This ObjectValue obj) {
    }
}

