/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.util;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import io.vertx.lang.php.AsyncResultHandler;
import io.vertx.lang.php.AsyncResultWrapper;
import io.vertx.lang.php.Handler;
import io.vertx.lang.php.ResultModifier;
import io.vertx.lang.php.util.PhpTypes;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.buffer.Buffer;

public class HandlerFactory {
    private HandlerFactory() {
    }

    public static <T> org.vertx.java.core.Handler<T> createGenericHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler);
        return new Handler(env, PhpTypes.toCallable(handler));
    }

    public static org.vertx.java.core.Handler<Void> createVoidHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler);
        return new Handler<Void>(env, PhpTypes.toCallable(handler)){

            @Override
            public void handle(Void arg) {
                Env env = this.getEnvironment();
                this.getCallable().call(env);
            }
        };
    }

    public static org.vertx.java.core.Handler<Buffer> createBufferHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler);
        return new Handler<Buffer>(env, PhpTypes.toCallable(handler), new ResultModifier<Buffer, io.vertx.lang.php.buffer.Buffer>(){

            @Override
            public io.vertx.lang.php.buffer.Buffer modify(Buffer buffer) {
                return new io.vertx.lang.php.buffer.Buffer(buffer);
            }
        });
    }

    public static org.vertx.java.core.Handler<Throwable> createExceptionHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler);
        return new Handler<Throwable>(env, PhpTypes.toCallable(handler));
    }

    public static <T> org.vertx.java.core.Handler<AsyncResult<T>> createAsyncGenericHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler);
        return new AsyncResultHandler(env, PhpTypes.toCallable(handler));
    }

    public static org.vertx.java.core.Handler<AsyncResult<Void>> createAsyncVoidHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler);
        return new AsyncResultHandler<Void>(env, PhpTypes.toCallable(handler)){

            @Override
            public void handle(AsyncResult<Void> result) {
                Env env = this.getEnvironment();
                if (result.succeeded()) {
                    this.getCallable().call(env, env.wrapJava(null));
                } else {
                    this.getCallable().call(env, env.wrapJava((Object)result.cause()));
                }
            }
        };
    }

    public static org.vertx.java.core.Handler<AsyncResult<Buffer>> createAsyncBufferHandler(Env env, Value handler) {
        PhpTypes.assertCallable(env, handler);
        return new AsyncResultHandler<Buffer>(env, PhpTypes.toCallable(handler), new AsyncResultWrapper<Buffer, io.vertx.lang.php.buffer.Buffer>(){

            @Override
            public io.vertx.lang.php.buffer.Buffer wrap(Buffer buffer) {
                return new io.vertx.lang.php.buffer.Buffer(buffer);
            }
        });
    }
}

