/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.php.util;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import java.util.Iterator;
import java.util.Map;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class PhpTypes {
    private PhpTypes() {
    }

    public static boolean isNull(Value value) {
        return value == null || value.isNull();
    }

    public static boolean isNull(Env env, Value value) {
        return PhpTypes.isNull(value);
    }

    public static void assertNull(Env env, Value value) {
        if (!PhpTypes.isNull(value)) {
            env.error(PhpTypes.buildErrorMessage(env, "Object is not null.", new Object[0]));
        }
    }

    public static void assertNull(Env env, Value value, String message, Object ... args) {
        if (!PhpTypes.isNull(value)) {
            env.error(PhpTypes.buildErrorMessage(env, message, args));
        }
    }

    public static boolean notNull(Value value) {
        return !PhpTypes.isNull(value);
    }

    public static boolean notNull(Env env, Value value) {
        return !PhpTypes.isNull(value);
    }

    public static void assertNotNull(Env env, Value value) {
        if (!PhpTypes.notNull(value)) {
            env.error(PhpTypes.buildErrorMessage(env, "Object is null.", new Object[0]));
        }
    }

    public static void assertNotNull(Env env, Value value, String message, Object ... args) {
        if (!PhpTypes.notNull(value)) {
            env.error(PhpTypes.buildErrorMessage(env, message, args));
        }
    }

    public static boolean isDefault(Value value) {
        return value != null && value.isDefault();
    }

    public static boolean isDefault(Env env, Value value) {
        return PhpTypes.isDefault(value);
    }

    public static void assertDefault(Env env, Value value) {
        if (!PhpTypes.isDefault(value)) {
            env.error(PhpTypes.buildErrorMessage(env, "Object is not default.", new Object[0]));
        }
    }

    public static void assertDefault(Env env, Value value, String message, Object ... args) {
        if (!PhpTypes.isDefault(value)) {
            env.error(PhpTypes.buildErrorMessage(env, message, args));
        }
    }

    public static boolean notDefault(Value value) {
        return value == null || !value.isDefault();
    }

    public static boolean notDefault(Env env, Value value) {
        return PhpTypes.notDefault(value);
    }

    public static void assertNotDefault(Env env, Value value) {
        if (!PhpTypes.notDefault(value)) {
            env.error(PhpTypes.buildErrorMessage(env, "Object is default.", new Object[0]));
        }
    }

    public static void assertNotDefault(Env env, Value value, String message, Object ... args) {
        if (!PhpTypes.notDefault(value)) {
            env.error(PhpTypes.buildErrorMessage(env, message, args));
        }
    }

    public static boolean isCallable(Env env, Value value) {
        return PhpTypes.notNull(value) && value.isCallable(env, false, null);
    }

    public static void assertCallable(Env env, Value value) {
        if (!PhpTypes.isCallable(env, value)) {
            env.error(PhpTypes.buildErrorMessage(env, "Object is not callable.", new Object[0]));
        }
    }

    public static void assertCallable(Env env, Value value, String message, Object ... args) {
        if (!PhpTypes.isCallable(env, value)) {
            env.error(PhpTypes.buildErrorMessage(env, message, args));
        }
    }

    public static Callable toCallable(Value value) {
        return value.toCallable(Env.getCurrent(), false);
    }

    public static Callable toCallable(Env env, Value value) {
        return value.toCallable(env, false);
    }

    public static Callable toCallable(Value value, boolean isOptional) {
        return value.toCallable(Env.getCurrent(), isOptional);
    }

    public static Callable toCallable(Env env, Value value, boolean isOptional) {
        return value.toCallable(env, isOptional);
    }

    public static void assertBoolean(Env env, Value value) {
        if (!value.isBoolean()) {
            env.error(PhpTypes.buildErrorMessage(env, "Invalid boolean value.", new Object[0]));
        }
    }

    public static void assertBoolean(Env env, Value value, String message, Object ... args) {
        if (!value.isBoolean()) {
            env.error(PhpTypes.buildErrorMessage(env, message, args));
        }
    }

    public static void assertInteger(Env env, Value value) {
        if (!value.isNumeric()) {
            env.error(PhpTypes.buildErrorMessage(env, "Invalid integer value.", new Object[0]));
        }
    }

    public static void assertInteger(Env env, Value value, String message, Object ... args) {
        if (!value.isNumeric()) {
            env.error(PhpTypes.buildErrorMessage(env, message, args));
        }
    }

    public static String buildErrorMessage(Env env, String message, Object ... args) {
        if (message.endsWith(".")) {
            message = message.substring(0, message.length() - 1);
        }
        Location location = env.getLocation();
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(message, args));
        String fileName = location.getUserPath();
        if (fileName == null) {
            fileName = location.getFileName();
        }
        if (fileName != null) {
            builder.append(" in ").append(fileName);
        }
        builder.append(" on line ").append(location.getLineNumber()).append(".");
        return builder.toString();
    }

    public static JsonObject arrayToJson(Env env, Value array) {
        return PhpTypes.arrayToJsonObject(env, array);
    }

    public static JsonObject arrayToJsonObject(Env env, Value array) {
        JsonObject json = new JsonObject();
        Iterator iter = array.getKeyIterator(env);
        while (iter.hasNext()) {
            Value key = (Value)iter.next();
            Value value = array.get(key);
            if (value.isArray()) {
                if (PhpTypes.arrayIsAssoc(env, value)) {
                    json.putObject(key.toString(), PhpTypes.arrayToJsonObject(env, value));
                    continue;
                }
                json.putArray(key.toString(), PhpTypes.arrayToJsonArray(env, value));
                continue;
            }
            if (value.isBoolean()) {
                json.putBoolean(key.toString(), Boolean.valueOf(value.toBoolean()));
                continue;
            }
            if (value.isDouble()) {
                json.putNumber(key.toString(), (Number)value.toJavaDouble());
                continue;
            }
            if (value.isNumeric()) {
                json.putNumber(key.toString(), (Number)value.toInt());
                continue;
            }
            if (value.isString()) {
                json.putString(key.toString(), value.toString());
                continue;
            }
            json.putValue(key.toString(), value.toJavaObject());
        }
        return json;
    }

    public static JsonArray arrayToJsonArray(Env env, Value array) {
        JsonArray json = new JsonArray();
        Iterator iter = array.getValueIterator(env);
        while (iter.hasNext()) {
            Value value = (Value)iter.next();
            if (value.isArray()) {
                if (PhpTypes.arrayIsAssoc(env, value)) {
                    json.addObject(PhpTypes.arrayToJsonObject(env, value));
                    continue;
                }
                json.addArray(PhpTypes.arrayToJsonArray(env, value));
                continue;
            }
            if (value.isBoolean()) {
                json.addBoolean(Boolean.valueOf(value.toBoolean()));
                continue;
            }
            if (value.isDouble()) {
                json.addNumber((Number)value.toJavaDouble());
                continue;
            }
            if (value.isNumeric()) {
                json.addNumber((Number)value.toInt());
                continue;
            }
            if (value.isString()) {
                json.addString(value.toString());
                continue;
            }
            json.add(value.toJavaObject());
        }
        return json;
    }

    private static boolean arrayIsAssoc(Env env, Value array) {
        Iterator iter = array.getKeyIterator(env);
        while (iter.hasNext()) {
            Value key = (Value)iter.next();
            if (!key.isString() && !key.isBoolean()) continue;
            return true;
        }
        return false;
    }

    public static ArrayValue arrayFromJson(Env env, JsonObject json) {
        ArrayValueImpl result = new ArrayValueImpl();
        Map map = json.toMap();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof JsonObject) {
                result.put((Value)env.createString(key), (Value)PhpTypes.arrayFromJson(env, (JsonObject)value));
                continue;
            }
            if (value instanceof JsonArray) {
                result.put((Value)env.createString(key), (Value)PhpTypes.arrayFromJson(env, (JsonArray)value));
                continue;
            }
            result.put((Value)env.createString(key), env.wrapJava(value));
        }
        return result;
    }

    public static ArrayValue arrayFromJson(Env env, JsonArray json) {
        ArrayValueImpl result = new ArrayValueImpl();
        Iterator iter = json.iterator();
        while (iter.hasNext()) {
            Object value = iter.next();
            if (value instanceof JsonObject) {
                result.put((Value)PhpTypes.arrayFromJson(env, (JsonObject)value));
                continue;
            }
            if (value instanceof JsonArray) {
                result.put((Value)PhpTypes.arrayFromJson(env, (JsonArray)value));
                continue;
            }
            result.put(env.wrapJava(iter.next()));
        }
        return result;
    }
}

