/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mongo;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.ext.auth.mongo.MongoAuthenticationOptions;
import io.vertx.ext.auth.mongo.MongoAuthorizationOptions;
import io.vertx.ext.auth.mongo.impl.MongoUserUtilImpl;
import io.vertx.ext.mongo.MongoClient;
import java.util.List;

@VertxGen
public interface MongoUserUtil {
    public static MongoUserUtil create(MongoClient client) {
        return new MongoUserUtilImpl(client);
    }

    public static MongoUserUtil create(MongoClient client, MongoAuthenticationOptions authenticationOptions, MongoAuthorizationOptions authorizationOptions) {
        return new MongoUserUtilImpl(client, authenticationOptions, authorizationOptions);
    }

    @Fluent
    public MongoUserUtil createUser(String var1, String var2, Handler<AsyncResult<String>> var3);

    default public Future<String> createUser(String username, String password) {
        Promise promise = Promise.promise();
        this.createUser(username, password, (Handler<AsyncResult<String>>)promise);
        return promise.future();
    }

    @Fluent
    public MongoUserUtil createHashedUser(String var1, String var2, Handler<AsyncResult<String>> var3);

    default public Future<String> createHashedUser(String username, String hash) {
        Promise promise = Promise.promise();
        this.createHashedUser(username, hash, (Handler<AsyncResult<String>>)promise);
        return promise.future();
    }

    @Fluent
    public MongoUserUtil createUserRolesAndPermissions(String var1, List<String> var2, List<String> var3, Handler<AsyncResult<String>> var4);

    default public Future<String> createUserRolesAndPermissions(String user, List<String> roles, List<String> permissions) {
        Promise promise = Promise.promise();
        this.createUserRolesAndPermissions(user, roles, permissions, (Handler<AsyncResult<String>>)promise);
        return promise.future();
    }
}

