/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mongo.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.HashingStrategy;
import io.vertx.ext.auth.mongo.MongoAuthenticationOptions;
import io.vertx.ext.auth.mongo.MongoAuthorizationOptions;
import io.vertx.ext.auth.mongo.MongoUserUtil;
import io.vertx.ext.mongo.MongoClient;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collections;
import java.util.List;

public class MongoUserUtilImpl
implements MongoUserUtil {
    private final MongoClient client;
    private final HashingStrategy strategy = HashingStrategy.load();
    private final SecureRandom random = new SecureRandom();
    private final MongoAuthenticationOptions authnOptions;
    private final MongoAuthorizationOptions authzOptions;

    public MongoUserUtilImpl(MongoClient client) {
        this(client, new MongoAuthenticationOptions(), new MongoAuthorizationOptions());
    }

    public MongoUserUtilImpl(MongoClient client, MongoAuthenticationOptions authnOptions, MongoAuthorizationOptions authzOptions) {
        this.client = client;
        this.authnOptions = authnOptions;
        this.authzOptions = authzOptions;
    }

    @Override
    public MongoUserUtil createUser(String username, String password, Handler<AsyncResult<String>> resultHandler) {
        if (username == null || password == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"username or password are null"));
            return this;
        }
        byte[] salt = new byte[32];
        this.random.nextBytes(salt);
        return this.createHashedUser(username, this.strategy.hash("pbkdf2", null, Base64.getMimeEncoder().encodeToString(salt), password), resultHandler);
    }

    @Override
    public MongoUserUtil createHashedUser(String username, String hash, Handler<AsyncResult<String>> resultHandler) {
        if (username == null || hash == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"username or password hash are null"));
            return this;
        }
        this.client.save(this.authnOptions.getCollectionName(), new JsonObject().put(this.authnOptions.getUsernameCredentialField(), (Object)username).put(this.authnOptions.getPasswordCredentialField(), (Object)hash), resultHandler);
        return this;
    }

    @Override
    public MongoUserUtil createUserRolesAndPermissions(String username, List<String> roles, List<String> permissions, Handler<AsyncResult<String>> resultHandler) {
        if (username == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"username is null"));
            return this;
        }
        this.client.save(this.authzOptions.getCollectionName(), new JsonObject().put(this.authzOptions.getUsernameField(), (Object)username).put(this.authzOptions.getRoleField(), roles == null ? Collections.emptyList() : roles).put(this.authzOptions.getPermissionField(), permissions == null ? Collections.emptyList() : permissions), resultHandler);
        return this;
    }
}

