/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.CircuitBreakerState;
import io.vertx.circuitbreaker.impl.MyAsyncOperations;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class APITest {
    private CircuitBreaker breaker;
    private Vertx vertx;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown() {
        if (this.breaker != null) {
            this.breaker.close();
        }
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close(ar -> completed.set(ar.succeeded()));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
    }

    @Test
    public void testWhenOptionsAreNull() {
        CircuitBreaker cb = CircuitBreaker.create((String)"name", (Vertx)this.vertx, null);
        Assertions.assertThat((Object)cb).isNotNull();
        Assertions.assertThat((String)cb.name()).isEqualTo((Object)"name");
        Assertions.assertThat((Comparable)cb.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
    }

    @Test
    public void testWithOperationWithHandler() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions());
        AtomicInteger result = new AtomicInteger();
        this.breaker.executeWithFallback(fut -> MyAsyncOperations.operation(1, 1, (Handler<AsyncResult<Integer>>)fut), v -> 0).onComplete(ar -> result.set((Integer)ar.result()));
        Awaitility.await().untilAtomic(result, Is.is((Object)2));
    }

    @Test
    public void testWithOperationWithCompletionHandler() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions());
        AtomicInteger result = new AtomicInteger();
        this.breaker.executeWithFallback(fut -> MyAsyncOperations.operation(1, 1, (Handler<AsyncResult<Integer>>)fut), v -> 0, ar -> result.set((Integer)ar.result()));
        Awaitility.await().untilAtomic(result, Is.is((Object)2));
    }

    @Test
    public void testWithFailingOperationWithHandler() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setFallbackOnFailure(true));
        AtomicInteger result = new AtomicInteger();
        this.breaker.executeWithFallback(fut -> MyAsyncOperations.fail((Promise<Integer>)fut), v -> -1).onComplete(ar -> result.set((Integer)ar.result()));
        Awaitility.await().untilAtomic(result, Is.is((Object)-1));
    }

    @Test
    public void testWithFailingOperationWithCompletionHandler() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setFallbackOnFailure(true));
        AtomicInteger result = new AtomicInteger();
        this.breaker.executeWithFallback(fut -> MyAsyncOperations.fail((Promise<Integer>)fut), v -> -1, ar -> result.set((Integer)ar.result()));
        Awaitility.await().untilAtomic(result, Is.is((Object)-1));
    }

    @Test
    public void testWithOperationWithFuture() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setFallbackOnFailure(true));
        AtomicInteger result = new AtomicInteger();
        Promise operationResult = Promise.promise();
        operationResult.future().onComplete(ar -> result.set((Integer)ar.result()));
        this.breaker.executeAndReport(operationResult, future -> MyAsyncOperations.operation((Promise<Integer>)future, 1, 1));
        Awaitility.await().untilAtomic(result, Is.is((Object)2));
    }

    @Test
    public void testWithFailingOperationWithFuture() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setFallbackOnFailure(true));
        AtomicInteger result = new AtomicInteger();
        Promise operationResult = Promise.promise();
        operationResult.future().onComplete(ar -> result.set((Integer)ar.result()));
        this.breaker.executeAndReportWithFallback(operationResult, MyAsyncOperations::fail, t -> -1);
        Awaitility.await().untilAtomic(result, Is.is((Object)-1));
    }
}

