/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=VertxUnitRunner.class)
public class AsyncBreakerTest {
    private Vertx vertx;
    private CircuitBreaker breaker;
    private int count;
    private static Logger LOG = LoggerFactory.getLogger(AsyncBreakerTest.class);

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.breaker = CircuitBreaker.create((String)"collector-circuit-breaker", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setMaxFailures(2).setTimeout(1000L).setFallbackOnFailure(false).setResetTimeout(2000L).setNotificationPeriod(0L));
        this.count = 0;
    }

    @After
    public void tearDown(TestContext tc) {
        this.vertx.close(tc.asyncAssertSuccess());
    }

    private void x(TestContext tc, int id) {
        Async async = tc.async(10);
        this.breaker.executeWithFallback(future -> this.vertx.setTimer((long)(100 + id * 10), handler -> {
            AsyncBreakerTest asyncBreakerTest = this;
            synchronized (asyncBreakerTest) {
                ++this.count;
                if (this.count < 5 || this.count > 12) {
                    future.complete((Object)"OK");
                    async.complete();
                } else {
                    future.fail("kapot");
                    async.complete();
                }
            }
        }), fallback -> {
            LOG.info("OPEN {}", (Object)id);
            async.complete();
            return "OPEN";
        });
    }

    @Test
    public void test1(TestContext tc) throws InterruptedException {
        for (int i = 0; i < 20; ++i) {
            this.x(tc, i);
        }
        this.breaker.openHandler(h -> LOG.info("Breaker open"));
        this.breaker.closeHandler(h -> tc.fail("should not close"));
        this.breaker.halfOpenHandler(h -> LOG.info("Breaker half open"));
    }

    @Test
    public void test2(TestContext tc) throws InterruptedException {
        int i;
        Async async = tc.async();
        for (i = 0; i < 20; ++i) {
            this.x(tc, i);
        }
        this.breaker.openHandler(h -> LOG.info("Breaker open"));
        this.breaker.closeHandler(h -> {
            LOG.info("Breaker closed");
            async.complete();
        });
        this.breaker.halfOpenHandler(h -> LOG.info("Breaker half open"));
        LOG.info("Waiting for test to complete");
        Thread.sleep(3000L);
        LOG.info("Sleep done");
        for (i = 0; i < 5; ++i) {
            this.x(tc, i);
        }
    }
}

