/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.CircuitBreakerState;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CircuitBreakerWithHTTPTest {
    private Vertx vertx;
    private HttpServer http;
    private HttpClient client;
    private CircuitBreaker breaker;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        Router router = Router.router((Vertx)this.vertx);
        router.route(HttpMethod.GET, "/").handler(ctxt -> ctxt.response().setStatusCode(200).end("hello"));
        router.route(HttpMethod.GET, "/error").handler(ctxt -> ctxt.response().setStatusCode(500).end("failed !"));
        router.route(HttpMethod.GET, "/long").handler(ctxt -> {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ctxt.response().setStatusCode(200).end("hello");
        });
        AtomicBoolean done = new AtomicBoolean();
        this.http = this.vertx.createHttpServer().requestHandler((Handler)router).listen(8080, ar -> done.set(ar.succeeded()));
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        this.client = this.vertx.createHttpClient();
    }

    @After
    public void tearDown() {
        if (this.breaker != null) {
            this.breaker.close();
        }
        AtomicBoolean completed = new AtomicBoolean();
        this.http.close(ar -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        completed.set(false);
        this.vertx.close(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        this.client.close();
    }

    @Test
    public void testOk() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions());
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        Promise result = Promise.promise();
        this.breaker.executeAndReport(result, v -> this.client.request(HttpMethod.GET, 8080, "localhost", "/").compose(req -> req.send().compose(resp -> resp.body().map(Buffer::toString))).onComplete((Handler)v));
        Awaitility.await().until(() -> result.future().result() != null);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
    }

    @Test
    public void testFailure() {
        CircuitBreakerOptions options = new CircuitBreakerOptions();
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            Promise result = Promise.promise();
            this.breaker.executeAndReport(result, future -> this.client.request(HttpMethod.GET, 8080, "localhost", "/error").compose(req -> req.send().compose(resp -> Future.succeededFuture((Object)resp.statusCode()))).onSuccess(sc -> {
                if (sc != 200) {
                    future.fail("http error");
                } else {
                    future.complete();
                }
                count.incrementAndGet();
            }));
        }
        Awaitility.await().untilAtomic(count, Is.is((Object)options.getMaxFailures()));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.OPEN);
        Promise result = Promise.promise();
        this.breaker.executeAndReportWithFallback(result, future -> this.client.request(HttpMethod.GET, 8080, "localhost", "/error").compose(req -> req.send().compose(resp -> Future.succeededFuture((Object)resp.statusCode()))).onSuccess(sc -> {
            if (sc != 200) {
                future.fail("http error");
            } else {
                future.complete();
            }
        }), v -> "fallback");
        Awaitility.await().until(() -> ((String)result.future().result()).equals("fallback"));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.OPEN);
    }

    @Test
    public void testTimeout() {
        CircuitBreakerOptions options = new CircuitBreakerOptions().setTimeout(100L).setMaxFailures(2);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(future -> this.client.request(HttpMethod.GET, 8080, "localhost", "/long").compose(req -> req.send().compose(HttpClientResponse::body).onSuccess(body -> {
                count.incrementAndGet();
                future.complete();
            })));
        }
        Awaitility.await().untilAtomic(count, Is.is((Object)options.getMaxFailures()));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.OPEN);
        Promise result = Promise.promise();
        this.breaker.executeAndReportWithFallback(result, future -> this.client.request(HttpMethod.GET, 8080, "localhost", "/long").compose(HttpClientRequest::send).onSuccess(response -> {
            System.out.println("Got response");
            future.complete();
        }), v -> "fallback");
        Awaitility.await().until(() -> ((String)result.future().result()).equals("fallback"));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.OPEN);
    }
}

