/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class HttpClientCommand
extends HystrixCommand<String> {
    private final HttpClient client;
    private final String path;

    public HttpClientCommand(HttpClient client, String path) {
        super(HystrixCommandGroupKey.Factory.asKey((String)"test"));
        this.client = client;
        this.path = path;
    }

    protected String run() throws Exception {
        AtomicReference result = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        Handler errorHandler = t -> latch.countDown();
        this.client.request(HttpMethod.GET, this.path, ar1 -> {
            if (ar1.succeeded()) {
                HttpClientRequest req = (HttpClientRequest)ar1.result();
                req.send(ar2 -> {
                    if (ar2.succeeded()) {
                        HttpClientResponse response = (HttpClientResponse)ar2.result();
                        response.exceptionHandler(errorHandler);
                        if (response.statusCode() != 200) {
                            latch.countDown();
                            return;
                        }
                        response.bodyHandler(content -> {
                            result.set(content.toString());
                            latch.countDown();
                        });
                    } else {
                        errorHandler.handle((Object)ar2.cause());
                    }
                });
            } else {
                errorHandler.handle((Object)ar1.cause());
            }
        });
        latch.await();
        if (result.get() == null) {
            throw new RuntimeException("Failed to retrieve the HTTP response");
        }
        return (String)result.get();
    }

    protected String getFallback() {
        return "fallback";
    }
}

