/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.circuitbreaker.impl.HttpClientCommand;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class HystrixTest {
    private Vertx vertx;
    private HttpServer http;
    private HttpClient client;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        Router router = Router.router((Vertx)this.vertx);
        router.route(HttpMethod.GET, "/").handler(ctxt -> ctxt.response().setStatusCode(200).end("hello"));
        router.route(HttpMethod.GET, "/error").handler(ctxt -> ctxt.response().setStatusCode(500).end("failed !"));
        router.route(HttpMethod.GET, "/long").handler(ctxt -> {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ctxt.response().setStatusCode(200).end("hello");
        });
        AtomicBoolean done = new AtomicBoolean();
        this.http = this.vertx.createHttpServer().requestHandler((Handler)router).listen(8080, ar -> done.set(ar.succeeded()));
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setDefaultPort(8080).setDefaultHost("localhost"));
    }

    @After
    public void tearDown() {
        AtomicBoolean completed = new AtomicBoolean();
        this.http.close(ar -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        completed.set(false);
        this.vertx.close(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        this.client.close();
    }

    @Test
    public void testOk() throws Exception {
        AtomicReference result = new AtomicReference();
        this.vertx.runOnContext(v -> this.vertx.executeBlocking(future -> {
            HttpClientCommand command = new HttpClientCommand(this.client, "/");
            future.complete(command.execute());
        }, ar -> result.set(ar.result())));
        Awaitility.await().until(() -> result.get() != null);
        Assertions.assertThat((String)((String)result.get())).isEqualToIgnoringCase((CharSequence)"hello");
        result.set(null);
        this.vertx.runOnContext(v -> this.vertx.executeBlocking(future -> {
            HttpClientCommand command = new HttpClientCommand(this.client, "/");
            try {
                future.complete(command.queue().get());
            }
            catch (Exception e) {
                future.fail((Throwable)e);
            }
        }, ar -> result.set(ar.result())));
        Awaitility.await().until(() -> result.get() != null);
        Assertions.assertThat((String)((String)result.get())).isEqualToIgnoringCase((CharSequence)"hello");
    }

    @Test
    public void testFailure() throws Exception {
        AtomicReference result = new AtomicReference();
        this.vertx.runOnContext(v -> this.vertx.executeBlocking(future -> {
            HttpClientCommand command = new HttpClientCommand(this.client, "/error");
            future.complete(command.execute());
        }, ar -> result.set(ar.result())));
        Awaitility.await().until(() -> result.get() != null);
        Assertions.assertThat((String)((String)result.get())).isEqualToIgnoringCase((CharSequence)"fallback");
        result.set(null);
        this.vertx.runOnContext(v -> this.vertx.executeBlocking(future -> {
            HttpClientCommand command = new HttpClientCommand(this.client, "/error");
            try {
                future.complete(command.queue().get());
            }
            catch (Exception e) {
                future.fail((Throwable)e);
            }
        }, ar -> result.set(ar.result())));
        Awaitility.await().until(() -> result.get() != null);
        Assertions.assertThat((String)((String)result.get())).isEqualToIgnoringCase((CharSequence)"fallback");
    }

    @Test
    public void testObservable() throws Exception {
        AtomicReference result = new AtomicReference();
        this.vertx.runOnContext(v -> {
            Context context = this.vertx.getOrCreateContext();
            HttpClientCommand command = new HttpClientCommand(this.client, "/");
            command.observe().subscribe(s -> context.runOnContext(v2 -> this.checkSetter(result, (String)s)));
        });
        Awaitility.await().until(() -> result.get() != null);
        Assertions.assertThat((String)((String)result.get())).isEqualToIgnoringCase((CharSequence)"hello");
    }

    private void checkSetter(AtomicReference<String> ref, String value) {
        if (Context.isOnEventLoopThread()) {
            ref.set(value);
        } else {
            ref.set("Not on the event loop");
        }
    }
}

