/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.jayway.awaitility.Awaitility;
import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.junit.Repeat;
import io.vertx.ext.unit.junit.RepeatRule;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class UsageTest {
    @Rule
    public RepeatRule repeatRule = new RepeatRule();
    @Rule
    public WireMockRule wireMockRule = new WireMockRule(8089);
    private Vertx vertx;
    private CircuitBreaker cb;
    private List<String> items = new ArrayList<String>();

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.items.clear();
        this.cb = CircuitBreaker.create((String)"circuit-breaker", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setFallbackOnFailure(true).setTimeout(500L).setResetTimeout(1000L));
        this.vertx.eventBus().consumer("ok", message -> message.reply((Object)"OK"));
        this.vertx.eventBus().consumer("fail", message -> message.fail(100, "Bad bad bad"));
        this.vertx.eventBus().consumer("exception", message -> {
            throw new RuntimeException("RT - Bad bad bad");
        });
        this.vertx.eventBus().consumer("timeout", message -> this.vertx.setTimer(2000L, x -> message.reply((Object)"Too late")));
    }

    @After
    public void tearDown() {
        this.cb.close();
        this.vertx.close();
    }

    @Test
    @Repeat(value=10)
    public void testCBWithReadOperation() {
        this.prepareHttpServer();
        HttpClient client = this.vertx.createHttpClient();
        AtomicReference json = new AtomicReference();
        this.cb.executeWithFallback(promise -> client.request(HttpMethod.GET, 8089, "localhost", "/resource").compose(req -> req.putHeader("Accept", "application/json").send().compose(resp -> resp.body().map(Buffer::toJsonObject))).onComplete((Handler)promise), t -> null).onComplete(ar -> json.set(ar.result()));
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).untilAtomic(json, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assertions.assertThat((String)((JsonObject)json.get()).getString("status")).isEqualTo((Object)"OK");
        json.set(null);
        this.cb.executeWithFallback(promise -> client.request(HttpMethod.GET, 8089, "localhost", "/error").compose(req -> req.putHeader("Accept", "application/json").send().compose(resp -> {
            if (resp.statusCode() != 200) {
                return Future.failedFuture((String)"Invalid response");
            }
            return resp.body().map(Buffer::toJsonObject);
        })).onComplete((Handler)promise), t -> new JsonObject().put("status", (Object)"KO")).onComplete(ar -> json.set(ar.result()));
        Awaitility.await().untilAtomic(json, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assertions.assertThat((String)((JsonObject)json.get()).getString("status")).isEqualTo((Object)"KO");
        json.set(null);
        this.cb.executeWithFallback(promise -> client.request(HttpMethod.GET, 8089, "localhost", "/delayed").compose(req -> req.putHeader("Accept", "application/json").send().compose(resp -> {
            if (resp.statusCode() != 200) {
                return Future.failedFuture((String)"Invalid response");
            }
            return resp.body().map(Buffer::toJsonObject);
        })).onComplete((Handler)promise), t -> new JsonObject().put("status", (Object)"KO")).onComplete(ar -> json.set(ar.result()));
        Awaitility.await().untilAtomic(json, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assertions.assertThat((String)((JsonObject)json.get()).getString("status")).isEqualTo((Object)"KO");
    }

    private void prepareHttpServer() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/resource")).withHeader("Accept", WireMock.equalTo((String)"application/json")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("{\"status\":\"OK\"}")));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/delayed")).willReturn(WireMock.aResponse().withStatus(200).withFixedDelay(Integer.valueOf(2000))));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/error")).willReturn(WireMock.aResponse().withStatus(500).withBody("This is an error")));
    }

    public void asyncWrite(String content, Scenario scenario, Handler<AsyncResult<Void>> resultHandler) {
        long random = (long)(Math.random() * 1000.0);
        switch (scenario) {
            case TIMEOUT: {
                random = 2000L;
                break;
            }
            case RUNTIME_EXCEPTION: {
                throw new RuntimeException("Bad bad bad");
            }
        }
        this.vertx.setTimer(random, l -> {
            if (scenario == Scenario.FAILURE) {
                UsageTest usageTest = this;
                synchronized (usageTest) {
                    this.items.add("Error");
                }
                resultHandler.handle((Object)Future.failedFuture((String)"Bad Bad Bad"));
            } else {
                UsageTest usageTest = this;
                synchronized (usageTest) {
                    this.items.add(content);
                }
                resultHandler.handle((Object)Future.succeededFuture());
            }
        });
    }

    @Test
    public void testCBWithWriteOperation() {
        this.cb.executeWithFallback(future -> this.asyncWrite("Hello", Scenario.OK, (Handler<AsyncResult<Void>>)future), t -> null);
        Awaitility.await().until(() -> {
            UsageTest usageTest = this;
            synchronized (usageTest) {
                return this.items.size() == 1;
            }
        });
        this.items.clear();
        AtomicBoolean fallbackCalled = new AtomicBoolean();
        this.cb.executeWithFallback(future -> this.asyncWrite("Hello", Scenario.FAILURE, (Handler<AsyncResult<Void>>)future), t -> {
            fallbackCalled.set(true);
            return null;
        });
        Awaitility.await().until(() -> {
            UsageTest usageTest = this;
            synchronized (usageTest) {
                return this.items.size() == 1;
            }
        });
        Assertions.assertThat((boolean)fallbackCalled.get()).isTrue();
        this.items.clear();
        fallbackCalled.set(false);
        this.cb.executeWithFallback(future -> this.asyncWrite("Hello", Scenario.TIMEOUT, (Handler<AsyncResult<Void>>)future), t -> {
            fallbackCalled.set(true);
            return null;
        });
        Awaitility.await().untilAtomic(fallbackCalled, CoreMatchers.is((Object)true));
        Assertions.assertThat(this.items).isEmpty();
        this.items.clear();
        fallbackCalled.set(false);
        this.cb.executeWithFallback(future -> this.asyncWrite("Hello", Scenario.RUNTIME_EXCEPTION, (Handler<AsyncResult<Void>>)future), t -> {
            fallbackCalled.set(true);
            return null;
        });
        Awaitility.await().untilAtomic(fallbackCalled, CoreMatchers.is((Object)true));
        Assertions.assertThat(this.items).isEmpty();
    }

    @Test
    public void testCBWithEventBus() {
        this.cb.executeWithFallback(future -> this.vertx.eventBus().request("ok", (Object)"", (Handler)future), t -> null).onComplete(ar -> this.items.add((String)((Message)ar.result()).body()));
        Awaitility.await().until(() -> {
            UsageTest usageTest = this;
            synchronized (usageTest) {
                return this.items.size() == 1;
            }
        });
        this.items.clear();
        AtomicBoolean fallbackCalled = new AtomicBoolean();
        this.cb.executeWithFallback(future -> this.vertx.eventBus().request("timeout", (Object)"", (Handler)future), t -> {
            fallbackCalled.set(true);
            return null;
        });
        Awaitility.await().untilAtomic(fallbackCalled, CoreMatchers.is((Object)true));
        Assertions.assertThat(this.items).isEmpty();
        fallbackCalled.set(false);
        this.cb.executeWithFallback(future -> this.vertx.eventBus().request("fail", (Object)"", (Handler)future), t -> {
            fallbackCalled.set(true);
            return null;
        });
        Awaitility.await().untilAtomic(fallbackCalled, CoreMatchers.is((Object)true));
        Assertions.assertThat(this.items).isEmpty();
        fallbackCalled.set(false);
        this.cb.executeWithFallback(future -> this.vertx.eventBus().request("exception", (Object)"", (Handler)future), t -> {
            fallbackCalled.set(true);
            return null;
        });
        Awaitility.await().untilAtomic(fallbackCalled, CoreMatchers.is((Object)true));
        Assertions.assertThat(this.items).isEmpty();
        fallbackCalled.set(false);
    }

    static enum Scenario {
        OK,
        FAILURE,
        RUNTIME_EXCEPTION,
        TIMEOUT;

    }
}

