/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.metrics;

import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.HystrixMetricHandler;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.Random;

public class DashboardExample {
    private static Random random = new Random();

    public static void main(String[] args) {
        Vertx vertx = Vertx.vertx();
        CircuitBreakerOptions options = new CircuitBreakerOptions().setFallbackOnFailure(true).setMaxFailures(10).setResetTimeout(5000L).setTimeout(1000L).setMetricsRollingWindow(10000L);
        CircuitBreaker cba = CircuitBreaker.create((String)"A", (Vertx)vertx, (CircuitBreakerOptions)options);
        CircuitBreaker cbb = CircuitBreaker.create((String)"B", (Vertx)vertx, (CircuitBreakerOptions)options);
        CircuitBreaker cbc = CircuitBreaker.create((String)"C", (Vertx)vertx, (CircuitBreakerOptions)options);
        Router router = Router.router((Vertx)vertx);
        router.get("/metrics").handler((Handler)HystrixMetricHandler.create((Vertx)vertx));
        router.get("/A").handler(rc -> DashboardExample.a(rc, cba));
        router.get("/B").handler(rc -> DashboardExample.b(rc, cbb));
        router.get("/C").handler(rc -> DashboardExample.c(rc, cbc));
        vertx.createHttpServer().requestHandler((Handler)router).listen(8080);
    }

    private static void a(RoutingContext rc, CircuitBreaker cb) {
        int choice = random.nextInt(10);
        if (choice < 7) {
            cb.executeWithFallback(DashboardExample.commandThatWorks(rc.vertx()), t -> "OK (fallback)").onComplete(s -> rc.response().end((String)s.result()));
        } else {
            cb.executeWithFallback(DashboardExample.commandThatFails(rc.vertx()), t -> "OK (fallback)").onComplete(s -> rc.response().end((String)s.result()));
        }
    }

    private static void b(RoutingContext rc, CircuitBreaker cb) {
        int choice = random.nextInt(10);
        if (choice < 5) {
            cb.executeWithFallback(DashboardExample.commandThatWorks(rc.vertx()), t -> "OK (fallback)").onComplete(s -> rc.response().end((String)s.result()));
        } else if (choice < 7) {
            cb.executeWithFallback(DashboardExample.commandThatCrashes(rc.vertx()), t -> "OK (fallback)").onComplete(s -> rc.response().end((String)s.result()));
        } else {
            cb.executeWithFallback(DashboardExample.commandThatFails(rc.vertx()), t -> "OK (fallback)").onComplete(s -> rc.response().end((String)s.result()));
        }
    }

    private static void c(RoutingContext rc, CircuitBreaker cb) {
        int choice = random.nextInt(10);
        if (choice < 5) {
            cb.executeWithFallback(DashboardExample.commandThatWorks(rc.vertx()), t -> "OK (fallback)").onComplete(s -> rc.response().end((String)s.result()));
        } else if (choice < 7) {
            cb.executeWithFallback(DashboardExample.commandThatTimeout(rc.vertx(), 15000), t -> "OK (fallback)").onComplete(s -> rc.response().end((String)s.result()));
        } else {
            cb.executeWithFallback(DashboardExample.commandThatFails(rc.vertx()), t -> "OK (fallback)").onComplete(s -> rc.response().end((String)s.result()));
        }
    }

    private static Handler<Promise<String>> commandThatWorks(Vertx vertx) {
        return future -> vertx.setTimer(5L, l -> future.complete((Object)"OK !"));
    }

    private static Handler<Promise<String>> commandThatFails(Vertx vertx) {
        return future -> vertx.setTimer(5L, l -> future.fail("expected failure"));
    }

    private static Handler<Promise<String>> commandThatCrashes(Vertx vertx) {
        return future -> {
            throw new RuntimeException("Expected error");
        };
    }

    private static Handler<Promise<String>> commandThatTimeout(Vertx vertx, int timeout) {
        return future -> vertx.setTimer((long)(timeout + 500), l -> future.complete((Object)"Is it too late ?"));
    }

    private static Handler<Promise<String>> commandThatTimeoutAndFail(Vertx vertx, int timeout) {
        return future -> vertx.setTimer((long)(timeout + 500), l -> future.fail("late failure"));
    }
}

